/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.artifactory.rest.handlers;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceAlreadyExistsException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Closeables2;
import org.jclouds.util.Strings2;

public class ArtifactoryErrorHandler
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        void var4_10;
        String message = this.parseMessage(response);
        HttpResponseException httpResponseException = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        try {
            message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
            switch (response.getStatusCode()) {
                case 400: {
                    if (!command.getCurrentRequest().getMethod().equals("POST")) break;
                    if (command.getCurrentRequest().getEndpoint().getPath().endsWith("/aql")) {
                        if (message.indexOf("Fail to parse query") == -1) break;
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message, (Throwable)httpResponseException);
                        break;
                    }
                    if (!command.getCurrentRequest().getEndpoint().getPath().startsWith("/api/build/promote")) break;
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message, (Throwable)httpResponseException);
                    break;
                }
                case 401: {
                    AuthorizationException authorizationException = new AuthorizationException(message, (Throwable)httpResponseException);
                    break;
                }
                case 404: {
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)httpResponseException);
                    break;
                }
                case 409: {
                    ResourceAlreadyExistsException resourceAlreadyExistsException = new ResourceAlreadyExistsException(message, (Throwable)httpResponseException);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Closeables2.closeQuietly((Closeable)response.getPayload());
            command.setException((Exception)httpResponseException);
            throw throwable;
        }
        Closeables2.closeQuietly((Closeable)response.getPayload());
        command.setException((Exception)var4_10);
    }

    public String parseMessage(HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        try {
            return Strings2.toStringAndClose((InputStream)response.getPayload().openStream());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

