/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.sync.SyncState;
import com.cdancy.bitbucket.rest.domain.sync.SyncStatus;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.SyncOptions;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/sync/{jclouds.api-version}/projects")
public interface SyncApi {
    @Named(value="sync:enable")
    @Documentation(value={"https://docs.atlassian.com/DAC/rest/stash/3.7.2/stash-repository-ref-sync-rest.html"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}")
    @Payload(value="%7B \"enabled\": \"{enabled}\" %7D")
    @Fallback(value=BitbucketFallbacks.SyncStatusOnError.class)
    @POST
    public SyncStatus enable(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PayloadParam(value="enabled") boolean var3);

    @Named(value="sync:status")
    @Documentation(value={"https://docs.atlassian.com/DAC/rest/stash/3.7.2/stash-repository-ref-sync-rest.html"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}")
    @Fallback(value=BitbucketFallbacks.SyncStatusOnError.class)
    @GET
    public SyncStatus status(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="at") String var3);

    @Named(value="sync:synchronize")
    @Documentation(value={"https://docs.atlassian.com/DAC/rest/stash/3.7.2/stash-repository-ref-sync-rest.html"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/synchronize")
    @Fallback(value=BitbucketFallbacks.SyncStateOnError.class)
    @POST
    public SyncState synchronize(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) SyncOptions var3);
}

