/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.domain.branch;

import com.cdancy.bitbucket.rest.domain.branch.AutoValue_Matcher;
import com.cdancy.bitbucket.rest.domain.branch.BranchRestrictionType;
import com.google.auto.value.AutoValue;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class Matcher {
    public abstract String id();

    public abstract String displayId();

    public abstract BranchRestrictionType type();

    public abstract Boolean active();

    @SerializedNames(value={"id", "displayId", "type", "active"})
    public static Matcher create(String id, String displayId, BranchRestrictionType type, Boolean active) {
        return new AutoValue_Matcher(id, displayId, type, active);
    }

    public static Matcher create(MatcherId matcherId, Boolean active) {
        return new AutoValue_Matcher(matcherId.getId(), matcherId.getName(), BranchRestrictionType.create(matcherId), active);
    }

    public static enum MatcherId {
        RELEASE("RELEASE", "Release", "MODEL_CATEGORY", "Branching model category"),
        DEVELOPMENT("Development", "Development", "MODEL_BRANCH", "Branching model branch"),
        MASTER("Production", "Production", "MODEL_BRANCH", "Branching model branch"),
        ANY_REF("ANY_REF_MATCHER_ID", "ANY_REF_MATCHER_ID", "ANY_REF", "Any branch"),
        ANY("any", "any", "ANY_REF", "ANY_REF");

        private final String id;
        private final String name;
        private final String typeId;
        private final String typeName;

        private MatcherId(String id, String name, String typeId, String typeName) {
            this.id = id;
            this.name = name;
            this.typeId = typeId;
            this.typeName = typeName;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeId() {
            return this.typeId;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

