/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.fallbacks;

import com.cdancy.bitbucket.rest.BitbucketUtils;
import com.cdancy.bitbucket.rest.domain.activities.ActivitiesPage;
import com.cdancy.bitbucket.rest.domain.admin.UserPage;
import com.cdancy.bitbucket.rest.domain.branch.Branch;
import com.cdancy.bitbucket.rest.domain.branch.BranchModel;
import com.cdancy.bitbucket.rest.domain.branch.BranchModelConfiguration;
import com.cdancy.bitbucket.rest.domain.branch.BranchPage;
import com.cdancy.bitbucket.rest.domain.branch.BranchRestrictionPage;
import com.cdancy.bitbucket.rest.domain.build.StatusPage;
import com.cdancy.bitbucket.rest.domain.comment.Comments;
import com.cdancy.bitbucket.rest.domain.comment.LikePage;
import com.cdancy.bitbucket.rest.domain.comment.Task;
import com.cdancy.bitbucket.rest.domain.commit.Commit;
import com.cdancy.bitbucket.rest.domain.commit.CommitPage;
import com.cdancy.bitbucket.rest.domain.common.Error;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.common.Veto;
import com.cdancy.bitbucket.rest.domain.defaultreviewers.Condition;
import com.cdancy.bitbucket.rest.domain.file.FilesPage;
import com.cdancy.bitbucket.rest.domain.file.LastModified;
import com.cdancy.bitbucket.rest.domain.file.LinePage;
import com.cdancy.bitbucket.rest.domain.file.RawContent;
import com.cdancy.bitbucket.rest.domain.insights.AnnotationsResponse;
import com.cdancy.bitbucket.rest.domain.insights.InsightReport;
import com.cdancy.bitbucket.rest.domain.insights.InsightReportPage;
import com.cdancy.bitbucket.rest.domain.labels.Label;
import com.cdancy.bitbucket.rest.domain.labels.LabelsPage;
import com.cdancy.bitbucket.rest.domain.participants.Participants;
import com.cdancy.bitbucket.rest.domain.participants.ParticipantsPage;
import com.cdancy.bitbucket.rest.domain.postwebhooks.PostWebHook;
import com.cdancy.bitbucket.rest.domain.project.Project;
import com.cdancy.bitbucket.rest.domain.project.ProjectPage;
import com.cdancy.bitbucket.rest.domain.project.ProjectPermissionsPage;
import com.cdancy.bitbucket.rest.domain.pullrequest.ChangePage;
import com.cdancy.bitbucket.rest.domain.pullrequest.CommentPage;
import com.cdancy.bitbucket.rest.domain.pullrequest.MergeStatus;
import com.cdancy.bitbucket.rest.domain.pullrequest.PullRequest;
import com.cdancy.bitbucket.rest.domain.pullrequest.PullRequestPage;
import com.cdancy.bitbucket.rest.domain.pullrequest.User;
import com.cdancy.bitbucket.rest.domain.repository.Hook;
import com.cdancy.bitbucket.rest.domain.repository.HookPage;
import com.cdancy.bitbucket.rest.domain.repository.HookSettings;
import com.cdancy.bitbucket.rest.domain.repository.PermissionsPage;
import com.cdancy.bitbucket.rest.domain.repository.PullRequestSettings;
import com.cdancy.bitbucket.rest.domain.repository.Repository;
import com.cdancy.bitbucket.rest.domain.repository.RepositoryPage;
import com.cdancy.bitbucket.rest.domain.repository.WebHook;
import com.cdancy.bitbucket.rest.domain.repository.WebHookPage;
import com.cdancy.bitbucket.rest.domain.sshkey.AccessKey;
import com.cdancy.bitbucket.rest.domain.sshkey.AccessKeyPage;
import com.cdancy.bitbucket.rest.domain.sync.SyncState;
import com.cdancy.bitbucket.rest.domain.sync.SyncStatus;
import com.cdancy.bitbucket.rest.domain.tags.Tag;
import com.cdancy.bitbucket.rest.domain.tags.TagPage;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jclouds.Fallback;
import org.jclouds.http.HttpUtils;

public final class BitbucketFallbacks {
    public static RequestStatus createRequestStatusFromErrors(List<Error> errors) {
        return RequestStatus.create(false, errors);
    }

    public static RawContent createRawContentFromErrors(List<Error> errors) {
        return RawContent.create(null, errors);
    }

    public static LinePage createLinePageFromErrors(List<Error> errors) {
        return LinePage.create(-1, -1, -1, -1, true, null, null, errors);
    }

    public static FilesPage createFilesPageFromErrors(List<Error> errors) {
        return FilesPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static LastModified createLastModifiedFromErrors(List<Error> errors) {
        return LastModified.create(null, null, errors);
    }

    public static Branch createBranchFromErrors(List<Error> errors) {
        return Branch.create(null, null, null, null, null, false, null, errors);
    }

    public static BranchModel createBranchModelFromErrors(List<Error> errors) {
        return BranchModel.create(null, null, null, errors);
    }

    public static BranchModelConfiguration createBranchModelConfigurationFromErrors(List<Error> errors) {
        return BranchModelConfiguration.create(null, null, null, errors);
    }

    public static BranchPage createBranchPageFromErrors(List<Error> errors) {
        return BranchPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static UserPage createUserPageFromErrors(List<Error> errors) {
        return UserPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static LikePage createLikePageFromErrors(List<Error> errors) {
        return LikePage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static User createUserFromErrors(List<Error> errors) {
        return User.create(errors, null, null, -1, null, false, null, null, null, false, -1L, false, false);
    }

    public static Condition createConditionFromErrors(List<Error> errors) {
        return Condition.create(null, null, null, null, null, null, errors);
    }

    public static StatusPage createStatusPageFromErrors(List<Error> errors) {
        return StatusPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static BranchRestrictionPage createBranchPermissionPageFromErrors(List<Error> errors) {
        return BranchRestrictionPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static ChangePage createChangePageFromErrors(List<Error> errors) {
        return ChangePage.create(0, 0, 0, 0, true, null, errors);
    }

    public static Comments createCommentsFromErrors(List<Error> errors) {
        return Comments.create(null, 0, 0, null, null, 0L, 0L, null, null, null, null, null, null, errors);
    }

    public static CommentPage createCommentPageFromErrors(List<Error> errors) {
        return CommentPage.create(0, 0, 0, 0, true, null, errors);
    }

    public static CommitPage createCommitPageFromErrors(List<Error> errors) {
        return CommitPage.create(0, 0, 0, 0, true, null, errors, -1, -1);
    }

    public static Commit createCommitFromErrors(List<Error> errors) {
        return Commit.create("-1", "-1", null, 0L, null, 0L, null, null, null, errors);
    }

    public static Tag createTagFromErrors(List<Error> errors) {
        return Tag.create(null, null, null, null, null, null, errors);
    }

    public static Task createTaskFromErrors(List<Error> errors) {
        return Task.create(null, null, -1L, -1, null, null, null, errors);
    }

    public static Repository createRepositoryFromErrors(List<Error> errors) {
        return Repository.create(null, -1, null, null, null, null, null, false, null, null, false, null, errors);
    }

    public static RepositoryPage createRepositoryPageFromErrors(List<Error> errors) {
        return RepositoryPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static PermissionsPage createPermissionsPageFromErrors(List<Error> errors) {
        return PermissionsPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static HookPage createHookPageFromErrors(List<Error> errors) {
        return HookPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static Hook createHookFromErrors(List<Error> errors) {
        return Hook.create(null, false, false, errors);
    }

    public static HookSettings createHookSettingsFromErrors(List<Error> errors) {
        return HookSettings.create(null, errors);
    }

    public static AnnotationsResponse createAnnotationsResponseFromErrors(List<Error> errors) {
        return AnnotationsResponse.create(0, null, errors);
    }

    public static InsightReportPage createInsightReportPageFromErrors(List<Error> errors) {
        return InsightReportPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static InsightReport createInsightReportFromErrors(List<Error> errors) {
        return InsightReport.create(-1L, null, null, null, null, null, null, null, null, errors);
    }

    public static Project createProjectFromErrors(List<Error> errors) {
        return Project.create(null, -1, null, null, false, null, null, errors);
    }

    public static ProjectPermissionsPage createProjectPermissionsPageFromErrors(List<Error> errors) {
        return ProjectPermissionsPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static PullRequestSettings createPullRequestSettingsFromErrors(List<Error> errors) {
        return PullRequestSettings.create(null, null, null, null, null, null, errors);
    }

    public static ProjectPage createProjectPageFromErrors(List<Error> errors) {
        return ProjectPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static PullRequest createPullRequestFromErrors(List<Error> errors) {
        return PullRequest.create(-1, -1, null, null, null, false, false, 0L, 0L, null, null, false, null, null, null, null, null, errors);
    }

    public static SyncState createSyncStateFromErrors(List<Error> errors) {
        return SyncState.create(null, null, null, null, errors);
    }

    public static SyncStatus createSyncStatusFromErrors(boolean isAvailable, List<Error> errors) {
        return SyncStatus.create(isAvailable, false, null, null, null, null, errors);
    }

    public static ActivitiesPage createActivitiesPageFromErrors(List<Error> errors) {
        return ActivitiesPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static ParticipantsPage createParticipantsPageFromErrors(List<Error> errors) {
        return ParticipantsPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static Participants createParticipantsFromErrors(List<Error> errors) {
        return Participants.create(null, null, Participants.Role.REVIEWER, false, Participants.Status.UNAPPROVED, errors);
    }

    public static PullRequestPage createPullRequestPageFromErrors(List<Error> errors) {
        return PullRequestPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static TagPage createTagPageFromErrors(List<Error> errors) {
        return TagPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static MergeStatus createMergeStatusFromErrors(List<Error> errors) {
        return MergeStatus.create(false, false, null, errors);
    }

    public static WebHookPage createWebHookPageFromErrors(List<Error> errors) {
        return WebHookPage.create(-1, -1, -1, -1, true, null, errors);
    }

    public static List<Error> createPostWebHookListFromErrors(List<Error> errors) {
        return errors;
    }

    public static WebHook createWebHookFromErrors(List<Error> errors) {
        return WebHook.create(null, null, -1L, -1L, null, null, null, false, errors);
    }

    public static PostWebHook createPostWebHookFromErrors(List<Error> errors) {
        return PostWebHook.create(false, false, null, null, false, false, false, false, false, false, false, false, false, false, false, null, null, errors);
    }

    public static AccessKey createAccessKeyFromErrors(List<Error> errors) {
        return AccessKey.create(null, null, null, null, errors);
    }

    public static AccessKeyPage createAccessKeyPageFromErrors(List<Error> errors) {
        return AccessKeyPage.create(0, 0, 0, 0, false, null, errors);
    }

    public static LabelsPage createLabelsPageFromErrors(List<Error> errors) {
        return LabelsPage.create(0, 0, 0, 0, false, null, errors);
    }

    public static Label createLabelByNameFromErrors(List<Error> errors) {
        return Label.create("", errors);
    }

    public static List<Error> getErrors(String output) {
        ArrayList errors;
        block5: {
            errors = Lists.newArrayList();
            try {
                JsonElement element = BitbucketUtils.JSON_PARSER.parse(output);
                JsonObject object = element.getAsJsonObject();
                if (object.has("errors")) {
                    JsonArray errorsArray = object.get("errors").getAsJsonArray();
                    Iterator it = errorsArray.iterator();
                    while (it.hasNext()) {
                        JsonObject obj = ((JsonElement)it.next()).getAsJsonObject();
                        errors.add(BitbucketFallbacks.getErrorFromJsonObject(obj));
                    }
                    break block5;
                }
                if (object.has("context")) {
                    errors.add(BitbucketFallbacks.getErrorFromJsonObject(object));
                    break block5;
                }
                throw new RuntimeException(output);
            }
            catch (Exception e) {
                Error error = Error.create(output, "Failed to parse output: message=" + e.getMessage(), e.getClass().getName(), false, null);
                errors.add(error);
            }
        }
        return errors;
    }

    public static Error getErrorFromJsonObject(JsonObject obj) {
        JsonElement context = obj.get("context");
        JsonElement message = obj.get("message");
        JsonElement exceptionName = obj.get("exceptionName");
        JsonElement conflicted = obj.get("conflicted");
        ArrayList vetos = Lists.newArrayList();
        JsonElement possibleVetoesArray = obj.get("vetoes");
        if (possibleVetoesArray != null && !possibleVetoesArray.isJsonNull()) {
            JsonArray vetoesArray = possibleVetoesArray.getAsJsonArray();
            Iterator vetoIterator = vetoesArray.iterator();
            while (vetoIterator.hasNext()) {
                JsonObject vetoObj = ((JsonElement)vetoIterator.next()).getAsJsonObject();
                JsonElement summary = vetoObj.get("summaryMessage");
                JsonElement detailed = vetoObj.get("detailedMessage");
                Veto veto = Veto.create(!summary.isJsonNull() ? summary.getAsString() : null, !detailed.isJsonNull() ? detailed.getAsString() : null);
                vetos.add(veto);
            }
        }
        return Error.create(!context.isJsonNull() ? context.getAsString() : null, !message.isJsonNull() ? message.getAsString() : null, !exceptionName.isJsonNull() ? exceptionName.getAsString() : null, conflicted != null && !conflicted.isJsonNull() ? conflicted.getAsBoolean() : false, vetos);
    }

    public static final class LabelByNameOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createLabelByNameFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class LabelsOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createLabelsPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class AccessKeyPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createAccessKeyPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class AccessKeyOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createAccessKeyFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class PostWebHookListOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createPostWebHookListFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class PostWebHookOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createPostWebHookFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class WebHookOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createWebHookFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class WebHookPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createWebHookPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class RequestStatusOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                try {
                    return BitbucketFallbacks.createRequestStatusFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
                }
                catch (JsonSyntaxException e) {
                    Error error = Error.create(null, throwable.getMessage(), throwable.getClass().getName(), false, null);
                    ArrayList errors = Lists.newArrayList((Object[])new Error[]{error});
                    return RequestStatus.create(false, errors);
                }
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class RawContentOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                Error error = Error.create(throwable.getMessage(), "Failed retrieving raw content", throwable.getClass().getName(), false, null);
                return RawContent.create(null, Lists.newArrayList((Object[])new Error[]{error}));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class LastModifiedOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createLastModifiedFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class FilesPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createFilesPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class LinePageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createLinePageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class MergeStatusOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createMergeStatusFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class TagPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createTagPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class PullRequestPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createPullRequestPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class ParticipantsOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createParticipantsFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class ParticipantsPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createParticipantsPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class ActivitiesPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createActivitiesPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class SyncStateOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                Boolean is204 = (Boolean)HttpUtils.returnValueOnCodeOrNull((Throwable)throwable, (Object)true, (Predicate)Predicates.equalTo((Object)204));
                if (is204 != null && is204.booleanValue()) {
                    return SyncState.create(null, null, "SYNCED", null, null);
                }
                return BitbucketFallbacks.createSyncStateFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class SyncStatusOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                Boolean is204 = (Boolean)HttpUtils.returnValueOnCodeOrNull((Throwable)throwable, (Object)true, (Predicate)Predicates.equalTo((Object)204));
                boolean isAvailable = is204 != null;
                List<Error> errors = BitbucketFallbacks.getErrors(throwable.getMessage());
                if (errors.size() > 0 && errors.get(0).context() != null && errors.get(0).context().startsWith("Error parsing input: Cannot invoke \"org.jclouds.io.Payload.openStream()\" because the return value of \"org.jclouds.http.HttpResponse.getPayload()\" is null")) {
                    return BitbucketFallbacks.createSyncStatusFromErrors(isAvailable, null);
                }
                return BitbucketFallbacks.createSyncStatusFromErrors(isAvailable, errors);
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class PullRequestOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createPullRequestFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class ProjectPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createProjectPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class PullRequestSettingsOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createPullRequestSettingsFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class ProjectPermissionsPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createProjectPermissionsPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class ProjectOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createProjectFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class InsightReportPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createInsightReportPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class InsightReportOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createInsightReportFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class AnnotationsResponseOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createAnnotationsResponseFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class HookSettingsOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createHookSettingsFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class HookOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createHookFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class HookPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createHookPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class PermissionsPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createPermissionsPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class RepositoryPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createRepositoryPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class RepositoryOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createRepositoryFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class TaskOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createTaskFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class TagOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createTagFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class CommitOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createCommitFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class CommitPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createCommitPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class CommentPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createCommentPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class CommentsOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createCommentsFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class ChangePageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createChangePageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class BranchPermissionPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createBranchPermissionPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class StatusPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createStatusPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class ConditionOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createConditionFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class UserOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createUserFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class UserPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createUserPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class LikePageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createLikePageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class BranchPageOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createBranchPageFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class BranchModelConfigurationOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createBranchModelConfigurationFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class BranchModelOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return BitbucketFallbacks.createBranchModelFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class BranchOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                Boolean obj = (Boolean)HttpUtils.returnValueOnCodeOrNull((Throwable)throwable, (Object)true, (Predicate)Predicates.equalTo((Object)204));
                if (obj != null) {
                    return Branch.create(null, null, null, null, null, false, null, null);
                }
                return BitbucketFallbacks.createBranchFromErrors(BitbucketFallbacks.getErrors(throwable.getMessage()));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }
}

