/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.comment.LikePage;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/comment-likes/{jclouds.api-version}/projects")
public interface LikesApi {
    @Named(value="comments:getLikes")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/4.0.1/bitbucket-comment-likes-rest.html"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/comments/{commentId}/likes")
    @Fallback(value=BitbucketFallbacks.LikePageOnError.class)
    @GET
    public LikePage getLikes(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @PathParam(value="commentId") int var4);

    @Named(value="comments:likeComment")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/4.0.1/bitbucket-comment-likes-rest.html"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/comments/{commentId}/likes")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @POST
    public RequestStatus likeComment(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @PathParam(value="commentId") int var4);

    @Named(value="comments:unlikeComment")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/4.0.1/bitbucket-comment-likes-rest.html"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/comments/{commentId}/likes")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus unlikeComment(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @PathParam(value="commentId") int var4);
}

