/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.activities.ActivitiesPage;
import com.cdancy.bitbucket.rest.domain.commit.CommitPage;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.participants.Participants;
import com.cdancy.bitbucket.rest.domain.participants.ParticipantsPage;
import com.cdancy.bitbucket.rest.domain.pullrequest.ChangePage;
import com.cdancy.bitbucket.rest.domain.pullrequest.MergeStatus;
import com.cdancy.bitbucket.rest.domain.pullrequest.PullRequest;
import com.cdancy.bitbucket.rest.domain.pullrequest.PullRequestPage;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateParticipants;
import com.cdancy.bitbucket.rest.options.CreatePullRequest;
import com.cdancy.bitbucket.rest.options.EditPullRequest;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/api/{jclouds.api-version}/projects")
public interface PullRequestApi {
    @Named(value="pull-request:get")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278120560"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}")
    @Fallback(value=BitbucketFallbacks.PullRequestOnError.class)
    @GET
    public PullRequest get(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3);

    @Named(value="pull-request:list")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278244864"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests")
    @Fallback(value=BitbucketFallbacks.PullRequestPageOnError.class)
    @GET
    public PullRequestPage list(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="direction") String var3, @Nullable @QueryParam(value="at") String var4, @Nullable @QueryParam(value="state") String var5, @Nullable @QueryParam(value="order") String var6, @Nullable @QueryParam(value="withAttributes") Boolean var7, @Nullable @QueryParam(value="withProperties") Boolean var8, @Nullable @QueryParam(value="start") Integer var9, @Nullable @QueryParam(value="limit") Integer var10);

    @Named(value="pull-request:create")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278226704"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests")
    @Fallback(value=BitbucketFallbacks.PullRequestOnError.class)
    @POST
    public PullRequest create(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) CreatePullRequest var3);

    @Named(value="pull-request:edit")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idp304"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}")
    @Fallback(value=BitbucketFallbacks.PullRequestOnError.class)
    @PUT
    public PullRequest edit(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @BinderParam(value=BindToJsonPayload.class) EditPullRequest var4);

    @Named(value="pull-request:delete")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.13.0/bitbucket-rest.html?utm_source=%2Fstatic%2Frest%2Fbitbucket-server%2Flatest%2Fbitbucket-rest.html&utm_medium=301#idm46209337261168"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @Payload(value="%7B \"version\": \"{version}\" %7D")
    @DELETE
    public RequestStatus delete(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") long var3, @PayloadParam(value="version") long var5);

    @Named(value="pull-request:merge")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278164320"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/merge")
    @Fallback(value=BitbucketFallbacks.PullRequestOnError.class)
    @POST
    public PullRequest merge(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @QueryParam(value="version") int var4);

    @Named(value="pull-request:can-merge")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278176112"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/merge")
    @Fallback(value=BitbucketFallbacks.MergeStatusOnError.class)
    @GET
    public MergeStatus canMerge(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3);

    @Named(value="pull-request:decline")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278147920"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/decline")
    @Fallback(value=BitbucketFallbacks.PullRequestOnError.class)
    @POST
    public PullRequest decline(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @QueryParam(value="version") int var4);

    @Named(value="pull-request:reopen")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278134496"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/reopen")
    @Fallback(value=BitbucketFallbacks.PullRequestOnError.class)
    @POST
    public PullRequest reopen(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @QueryParam(value="version") int var4);

    @Named(value="pull-request:changes")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888279438576"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/changes")
    @Fallback(value=BitbucketFallbacks.ChangePageOnError.class)
    @GET
    public ChangePage changes(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @Nullable @QueryParam(value="withComments") Boolean var4, @Nullable @QueryParam(value="limit") Integer var5, @Nullable @QueryParam(value="start") Integer var6);

    @Named(value="pull-request:commits")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278089280"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/commits")
    @Fallback(value=BitbucketFallbacks.CommitPageOnError.class)
    @GET
    public CommitPage commits(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @Nullable @QueryParam(value="withCounts") Boolean var4, @Nullable @QueryParam(value="limit") Integer var5, @Nullable @QueryParam(value="start") Integer var6);

    @Named(value="pull-request:list-activities")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278197104"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/activities")
    @Fallback(value=BitbucketFallbacks.ActivitiesPageOnError.class)
    @GET
    public ActivitiesPage listActivities(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") long var3, @Nullable @QueryParam(value="limit") Integer var5, @Nullable @QueryParam(value="start") Integer var6);

    @Named(value="pull-request:list-participants")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45627978405632"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/participants")
    @Fallback(value=BitbucketFallbacks.ParticipantsPageOnError.class)
    @GET
    public ParticipantsPage listParticipants(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") long var3, @Nullable @QueryParam(value="limit") Integer var5, @Nullable @QueryParam(value="start") Integer var6);

    @Named(value="pull-request:assign-participants")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45627978396928"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/participants")
    @Fallback(value=BitbucketFallbacks.ParticipantsOnError.class)
    @POST
    public Participants assignParticipant(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") long var3, @BinderParam(value=BindToJsonPayload.class) CreateParticipants var5);

    @Named(value="pull-request:delete-participants")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45627978369040"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/participants/{userSlug}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deleteParticipant(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") long var3, @PathParam(value="userSlug") String var5);

    @Named(value="pull-request:add-participant")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm46358292595040"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/participants/{userSlug}")
    @Fallback(value=BitbucketFallbacks.ParticipantsOnError.class)
    @PUT
    public Participants addParticipant(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") long var3, @PathParam(value="userSlug") String var5, @BinderParam(value=BindToJsonPayload.class) CreateParticipants var6);
}

