/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.filters;

import com.cdancy.bitbucket.rest.BitbucketAuthentication;
import com.cdancy.bitbucket.rest.auth.AuthenticationType;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;

@Singleton
public class BitbucketAuthenticationFilter
implements HttpRequestFilter {
    private final BitbucketAuthentication creds;

    @Inject
    BitbucketAuthenticationFilter(BitbucketAuthentication creds) {
        this.creds = creds;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        if (this.creds.authType() == AuthenticationType.Anonymous) {
            return request;
        }
        String authHeader = this.creds.authType() + " " + this.creds.authValue();
        return ((HttpRequest.Builder)request.toBuilder().addHeader("Authorization", new String[]{authHeader})).build();
    }
}

