/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.tags.Tag;
import com.cdancy.bitbucket.rest.domain.tags.TagPage;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateTag;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest")
public interface TagApi {
    @Named(value="tag:create")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278801952"})
    @Consumes(value={"application/json"})
    @Path(value="/api/{jclouds.api-version}/projects/{project}/repos/{repo}/tags")
    @Fallback(value=BitbucketFallbacks.TagOnError.class)
    @POST
    public Tag create(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) CreateTag var3);

    @Named(value="tag:get")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278800832"})
    @Consumes(value={"application/json"})
    @Path(value="/api/{jclouds.api-version}/projects/{project}/repos/{repo}/tags/{tag}")
    @Fallback(value=BitbucketFallbacks.TagOnError.class)
    @GET
    public Tag get(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="tag") String var3);

    @Named(value="tag:list")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.7.0/bitbucket-rest.html#idm45568367769888"})
    @Consumes(value={"application/json"})
    @Path(value="/api/{jclouds.api-version}/projects/{project}/repos/{repo}/tags")
    @Fallback(value=BitbucketFallbacks.TagPageOnError.class)
    @GET
    public TagPage list(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="filterText") String var3, @Nullable @QueryParam(value="orderBy") String var4, @Nullable @QueryParam(value="start") Integer var5, @Nullable @QueryParam(value="limit") Integer var6);

    @Named(value="tag:delete")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.4.0/bitbucket-git-rest.html#idm139355817865616"})
    @Consumes(value={"application/json"})
    @Path(value="/git/{jclouds.api-version}/projects/{project}/repos/{repo}/tags/{tag}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus delete(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="tag") String var3);
}

