/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.features;

import com.cdancy.jenkins.rest.binders.BindMapToForm;
import com.cdancy.jenkins.rest.domain.common.IntegerResponse;
import com.cdancy.jenkins.rest.domain.common.RequestStatus;
import com.cdancy.jenkins.rest.domain.job.BuildInfo;
import com.cdancy.jenkins.rest.domain.job.JobInfo;
import com.cdancy.jenkins.rest.domain.job.JobList;
import com.cdancy.jenkins.rest.domain.job.PipelineNode;
import com.cdancy.jenkins.rest.domain.job.ProgressiveText;
import com.cdancy.jenkins.rest.domain.job.Workflow;
import com.cdancy.jenkins.rest.fallbacks.JenkinsFallbacks;
import com.cdancy.jenkins.rest.filters.JenkinsAuthenticationFilter;
import com.cdancy.jenkins.rest.parsers.BuildNumberToInteger;
import com.cdancy.jenkins.rest.parsers.FolderPathParser;
import com.cdancy.jenkins.rest.parsers.LocationToQueueId;
import com.cdancy.jenkins.rest.parsers.OptionalFolderPathParser;
import com.cdancy.jenkins.rest.parsers.OutputToProgressiveText;
import com.cdancy.jenkins.rest.parsers.RequestStatusParser;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={JenkinsAuthenticationFilter.class})
@Path(value="/")
public interface JobsApi {
    @Named(value="jobs:get-jobs")
    @Path(value="{folderPath}api/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public JobList jobList(@PathParam(value="folderPath") @ParamParser(value=FolderPathParser.class) String var1);

    @Named(value="jobs:job-info")
    @Path(value="{optionalFolderPath}job/{name}/api/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public JobInfo jobInfo(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:build-info")
    @Path(value="{optionalFolderPath}job/{name}/{number}/api/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public BuildInfo buildInfo(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3);

    @Named(value="jobs:create")
    @Path(value="{optionalFolderPath}createItem")
    @Fallback(value=JenkinsFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @Produces(value={"application/xml"})
    @Consumes(value={"*/*"})
    @Payload(value="{configXML}")
    @POST
    public RequestStatus create(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @QueryParam(value="name") String var2, @PayloadParam(value="configXML") String var3);

    @Named(value="jobs:get-config")
    @Path(value="{optionalFolderPath}job/{name}/config.xml")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"text/plain"})
    @GET
    public String config(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:update-config")
    @Path(value="{optionalFolderPath}job/{name}/config.xml")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Produces(value={"application/xml"})
    @Consumes(value={"text/html"})
    @Payload(value="{configXML}")
    @POST
    public boolean config(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PayloadParam(value="configXML") String var3);

    @Named(value="jobs:get-description")
    @Path(value="{optionalFolderPath}job/{name}/description")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"text/plain"})
    @GET
    public String description(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:set-description")
    @Path(value="{optionalFolderPath}job/{name}/description")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"text/html"})
    @POST
    public boolean description(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @FormParam(value="description") String var3);

    @Named(value="jobs:delete")
    @Path(value="{optionalFolderPath}job/{name}/doDelete")
    @Consumes(value={"text/html"})
    @Fallback(value=JenkinsFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @POST
    public RequestStatus delete(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:enable")
    @Path(value="{optionalFolderPath}job/{name}/enable")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"text/html"})
    @POST
    public boolean enable(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:disable")
    @Path(value="{optionalFolderPath}job/{name}/disable")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"text/html"})
    @POST
    public boolean disable(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:build")
    @Path(value="{optionalFolderPath}job/{name}/build")
    @Fallback(value=JenkinsFallbacks.IntegerResponseOnError.class)
    @ResponseParser(value=LocationToQueueId.class)
    @Consumes(value={"application/unknown"})
    @POST
    public IntegerResponse build(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:build-with-params")
    @Path(value="{optionalFolderPath}job/{name}/buildWithParameters")
    @Fallback(value=JenkinsFallbacks.IntegerResponseOnError.class)
    @ResponseParser(value=LocationToQueueId.class)
    @Consumes(value={"application/unknown"})
    @POST
    public IntegerResponse buildWithParameters(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @Nullable @BinderParam(value=BindMapToForm.class) Map<String, List<String>> var3);

    @Named(value="jobs:last-build-number")
    @Path(value="{optionalFolderPath}job/{name}/lastBuild/buildNumber")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=BuildNumberToInteger.class)
    @Consumes(value={"text/plain"})
    @GET
    public Integer lastBuildNumber(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:last-build-timestamp")
    @Path(value="{optionalFolderPath}job/{name}/lastBuild/buildTimestamp")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"text/plain"})
    @GET
    public String lastBuildTimestamp(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:progressive-text")
    @Path(value="{optionalFolderPath}job/{name}/lastBuild/logText/progressiveText")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=OutputToProgressiveText.class)
    @Consumes(value={"text/plain"})
    @GET
    public ProgressiveText progressiveText(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @QueryParam(value="start") int var3);

    @Named(value="jobs:progressive-text")
    @Path(value="{optionalFolderPath}job/{name}/{number}/logText/progressiveText")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=OutputToProgressiveText.class)
    @Consumes(value={"text/plain"})
    @GET
    public ProgressiveText progressiveText(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3, @QueryParam(value="start") int var4);

    @Named(value="jobs:rename")
    @Path(value="{optionalFolderPath}job/{name}/doRename")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"text/html"})
    @POST
    public boolean rename(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @QueryParam(value="newName") String var3);

    @Named(value="jobs:workflow")
    @Path(value="{optionalFolderPath}job/{name}/{number}/wfapi/describe")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public Workflow workflow(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3);

    @Named(value="jobs:pipeline-node")
    @Path(value="{optionalFolderPath}job/{name}/{number}/execution/node/{nodeId}/wfapi/describe")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public PipelineNode pipelineNode(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3, @PathParam(value="nodeId") int var4);
}

