/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.features;

import com.cdancy.jenkins.rest.binders.BindMapToForm;
import com.cdancy.jenkins.rest.domain.common.IntegerResponse;
import com.cdancy.jenkins.rest.domain.common.RequestStatus;
import com.cdancy.jenkins.rest.domain.job.BuildInfo;
import com.cdancy.jenkins.rest.domain.job.JobInfo;
import com.cdancy.jenkins.rest.domain.job.JobList;
import com.cdancy.jenkins.rest.domain.job.PipelineNode;
import com.cdancy.jenkins.rest.domain.job.PipelineNodeLog;
import com.cdancy.jenkins.rest.domain.job.ProgressiveText;
import com.cdancy.jenkins.rest.domain.job.Workflow;
import com.cdancy.jenkins.rest.fallbacks.JenkinsFallbacks;
import com.cdancy.jenkins.rest.filters.JenkinsAuthenticationFilter;
import com.cdancy.jenkins.rest.parsers.BuildNumberToInteger;
import com.cdancy.jenkins.rest.parsers.FolderPathParser;
import com.cdancy.jenkins.rest.parsers.LocationToQueueId;
import com.cdancy.jenkins.rest.parsers.OptionalFolderPathParser;
import com.cdancy.jenkins.rest.parsers.OutputToProgressiveText;
import com.cdancy.jenkins.rest.parsers.RequestStatusParser;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.JsonObject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.javax.ws.rs.Consumes;
import io.github.cdancy.jenkins.rest.shaded.javax.ws.rs.FormParam;
import io.github.cdancy.jenkins.rest.shaded.javax.ws.rs.GET;
import io.github.cdancy.jenkins.rest.shaded.javax.ws.rs.POST;
import io.github.cdancy.jenkins.rest.shaded.javax.ws.rs.Path;
import io.github.cdancy.jenkins.rest.shaded.javax.ws.rs.PathParam;
import io.github.cdancy.jenkins.rest.shaded.javax.ws.rs.Produces;
import io.github.cdancy.jenkins.rest.shaded.javax.ws.rs.QueryParam;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.Fallbacks;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.javax.annotation.Nullable;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.BinderParam;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.Fallback;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.ParamParser;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.Payload;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.PayloadParam;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.RequestFilters;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.ResponseParser;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

@RequestFilters(value={JenkinsAuthenticationFilter.class})
@Path(value="/")
public interface JobsApi {
    @Named(value="jobs:get-jobs")
    @Path(value="{folderPath}api/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public JobList jobList(@PathParam(value="folderPath") @ParamParser(value=FolderPathParser.class) String var1);

    @Named(value="jobs:job-info")
    @Path(value="{optionalFolderPath}job/{name}/api/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public JobInfo jobInfo(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:artifact")
    @Path(value="{optionalFolderPath}job/{name}/{number}/api/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public BuildInfo buildInfo(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3);

    @Named(value="jobs:artifact")
    @Path(value="{optionalFolderPath}job/{name}/{number}/artifact/{relativeArtifactPath}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    @GET
    public InputStream artifact(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3, @PathParam(value="relativeArtifactPath") String var4);

    @Named(value="jobs:create")
    @Path(value="{optionalFolderPath}createItem")
    @Fallback(value=JenkinsFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @Produces(value={"application/xml"})
    @Consumes(value={"*/*"})
    @Payload(value="{configXML}")
    @POST
    public RequestStatus create(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @QueryParam(value="name") String var2, @PayloadParam(value="configXML") String var3);

    @Named(value="jobs:get-config")
    @Path(value="{optionalFolderPath}job/{name}/config.xml")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"text/plain"})
    @GET
    public String config(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:update-config")
    @Path(value="{optionalFolderPath}job/{name}/config.xml")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Produces(value={"application/xml;charset=UTF-8"})
    @Consumes(value={"text/html"})
    @Payload(value="{configXML}")
    @POST
    public boolean config(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PayloadParam(value="configXML") String var3);

    @Named(value="jobs:get-description")
    @Path(value="{optionalFolderPath}job/{name}/description")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"text/plain"})
    @GET
    public String description(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:set-description")
    @Path(value="{optionalFolderPath}job/{name}/description")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"text/html"})
    @POST
    public boolean description(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @FormParam(value="description") String var3);

    @Named(value="jobs:delete")
    @Path(value="{optionalFolderPath}job/{name}/doDelete")
    @Consumes(value={"text/html"})
    @Fallback(value=JenkinsFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @POST
    public RequestStatus delete(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:enable")
    @Path(value="{optionalFolderPath}job/{name}/enable")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"text/html"})
    @POST
    public boolean enable(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:disable")
    @Path(value="{optionalFolderPath}job/{name}/disable")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"text/html"})
    @POST
    public boolean disable(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:build")
    @Path(value="{optionalFolderPath}job/{name}/build")
    @Fallback(value=JenkinsFallbacks.IntegerResponseOnError.class)
    @ResponseParser(value=LocationToQueueId.class)
    @Consumes(value={"application/unknown"})
    @POST
    public IntegerResponse build(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:stop-build")
    @Path(value="{optionalFolderPath}job/{name}/{number}/stop")
    @Fallback(value=JenkinsFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @Consumes(value={"application/json"})
    @POST
    public RequestStatus stop(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3);

    @Named(value="jobs:term-build")
    @Path(value="{optionalFolderPath}job/{name}/{number}/term")
    @Fallback(value=JenkinsFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @Consumes(value={"application/json"})
    @POST
    public RequestStatus term(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3);

    @Named(value="jobs:kill-build")
    @Path(value="{optionalFolderPath}job/{name}/{number}/kill")
    @Fallback(value=JenkinsFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @Consumes(value={"application/json"})
    @POST
    public RequestStatus kill(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3);

    @Named(value="jobs:build-with-params")
    @Path(value="{optionalFolderPath}job/{name}/buildWithParameters")
    @Fallback(value=JenkinsFallbacks.IntegerResponseOnError.class)
    @ResponseParser(value=LocationToQueueId.class)
    @Consumes(value={"application/unknown"})
    @POST
    public IntegerResponse buildWithParameters(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @Nullable @BinderParam(value=BindMapToForm.class) Map<String, List<String>> var3);

    @Named(value="jobs:last-build-number")
    @Path(value="{optionalFolderPath}job/{name}/lastBuild/buildNumber")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=BuildNumberToInteger.class)
    @Consumes(value={"text/plain"})
    @GET
    public Integer lastBuildNumber(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:last-build-timestamp")
    @Path(value="{optionalFolderPath}job/{name}/lastBuild/buildTimestamp")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"text/plain"})
    @GET
    public String lastBuildTimestamp(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:progressive-text")
    @Path(value="{optionalFolderPath}job/{name}/lastBuild/logText/progressiveText")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=OutputToProgressiveText.class)
    @Consumes(value={"text/plain"})
    @GET
    public ProgressiveText progressiveText(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @QueryParam(value="start") int var3);

    @Named(value="jobs:progressive-text")
    @Path(value="{optionalFolderPath}job/{name}/{number}/logText/progressiveText")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=OutputToProgressiveText.class)
    @Consumes(value={"text/plain"})
    @GET
    public ProgressiveText progressiveText(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3, @QueryParam(value="start") int var4);

    @Named(value="jobs:rename")
    @Path(value="{optionalFolderPath}job/{name}/doRename")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"text/html"})
    @POST
    public boolean rename(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @QueryParam(value="newName") String var3);

    @Named(value="jobs:run-history")
    @Path(value="{optionalFolderPath}job/{name}/wfapi/runs")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public List<Workflow> runHistory(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2);

    @Named(value="jobs:workflow")
    @Path(value="{optionalFolderPath}job/{name}/{number}/wfapi/describe")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public Workflow workflow(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3);

    @Named(value="jobs:pipeline-node")
    @Path(value="{optionalFolderPath}job/{name}/{number}/execution/node/{nodeId}/wfapi/describe")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public PipelineNode pipelineNode(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3, @PathParam(value="nodeId") int var4);

    @Named(value="jobs:pipeline-node-log")
    @Path(value="{optionalFolderPath}job/{name}/{number}/execution/node/{nodeId}/wfapi/log")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public PipelineNodeLog pipelineNodeLog(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3, @PathParam(value="nodeId") int var4);

    @Named(value="jobs:testReport")
    @Path(value="{optionalFolderPath}job/{name}/{number}/testReport/api/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public JsonObject testReport(@Nullable @PathParam(value="optionalFolderPath") @ParamParser(value=OptionalFolderPathParser.class) String var1, @PathParam(value="name") String var2, @PathParam(value="number") int var3);
}

