/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.filters;

import com.cdancy.jenkins.rest.JenkinsApi;
import com.cdancy.jenkins.rest.JenkinsAuthentication;
import com.cdancy.jenkins.rest.auth.AuthenticationType;
import com.cdancy.jenkins.rest.domain.crumb.Crumb;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpMessage;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequestFilter;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.ResourceNotFoundException;
import java.util.Optional;

@Singleton
public class JenkinsAuthenticationFilter
implements HttpRequestFilter {
    private final JenkinsAuthentication creds;
    private final JenkinsApi jenkinsApi;
    private volatile Pair<Crumb, Boolean> crumbPair = null;
    private static final String CRUMB_HEADER = "Jenkins-Crumb";
    private static final String RNFSimpleName = ResourceNotFoundException.class.getSimpleName();

    @Inject
    JenkinsAuthenticationFilter(JenkinsAuthentication creds, JenkinsApi jenkinsApi) {
        this.creds = creds;
        this.jenkinsApi = jenkinsApi;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        HttpMessage.Builder builder = request.toBuilder();
        if (this.creds.authType() == AuthenticationType.UsernameApiToken || this.creds.authType() == AuthenticationType.UsernamePassword) {
            String authHeader = this.creds.authType().getAuthScheme() + " " + this.creds.authValue();
            builder.addHeader("Authorization", authHeader);
        }
        if (request.getMethod().equals("POST") && (this.creds.authType() == AuthenticationType.UsernamePassword || this.creds.authType() == AuthenticationType.Anonymous)) {
            Pair<Crumb, Boolean> localCrumb = this.getCrumb();
            if (localCrumb.getKey().value() != null) {
                builder.addHeader(CRUMB_HEADER, localCrumb.getKey().value());
                Optional.ofNullable(localCrumb.getKey().sessionIdCookie()).ifPresent(arg_0 -> JenkinsAuthenticationFilter.lambda$filter$0((HttpRequest.Builder)builder, arg_0));
            } else if (!localCrumb.getValue().booleanValue()) {
                throw new RuntimeException("Unexpected exception being thrown: error=" + localCrumb.getKey().errors().get(0));
            }
        }
        return ((HttpRequest.Builder)builder).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Crumb, Boolean> getCrumb() {
        Pair<Crumb, Boolean> crumbValueInit = this.crumbPair;
        if (crumbValueInit == null) {
            JenkinsAuthenticationFilter jenkinsAuthenticationFilter = this;
            synchronized (jenkinsAuthenticationFilter) {
                crumbValueInit = this.crumbPair;
                if (crumbValueInit == null) {
                    Crumb crumb = this.jenkinsApi.crumbIssuerApi().crumb();
                    Boolean isRNFE = crumb.errors().isEmpty() || crumb.errors().get(0).exceptionName().endsWith(RNFSimpleName);
                    this.crumbPair = crumbValueInit = new Pair<Crumb, Boolean>(crumb, isRNFE);
                }
            }
        }
        return crumbValueInit;
    }

    private static /* synthetic */ void lambda$filter$0(HttpRequest.Builder builder, String sessionId) {
        builder.addHeader("Cookie", sessionId);
    }

    private static class Pair<A, B> {
        private final A a;
        private final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getKey() {
            return this.a;
        }

        public B getValue() {
            return this.b;
        }
    }
}

