/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.parsers;

import com.cdancy.jenkins.rest.domain.crumb.Crumb;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Strings2;
import java.io.IOException;

@Singleton
public class CrumbParser
implements Function<HttpResponse, Crumb> {
    @Override
    public Crumb apply(HttpResponse input) {
        if (input == null) {
            throw new RuntimeException("Unexpected NULL HttpResponse object");
        }
        int statusCode = input.getStatusCode();
        if (statusCode >= 200 && statusCode < 400) {
            try {
                return Crumb.create(CrumbParser.crumbValue(input), CrumbParser.sessionIdCookie(input));
            }
            catch (IOException e) {
                throw new RuntimeException(input.getStatusLine(), e);
            }
        }
        throw new RuntimeException(input.getStatusLine());
    }

    private static String crumbValue(HttpResponse input) throws IOException {
        return Strings2.toStringAndClose(input.getPayload().openStream()).split(":")[1];
    }

    private static String sessionIdCookie(HttpResponse input) {
        return input.getHeaders().get("Set-Cookie").stream().filter(c -> c.startsWith("JSESSIONID")).findFirst().orElse("");
    }
}

