/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.parsers;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;

@Singleton
public class FolderPathParser
implements Function<Object, String> {
    public static final String EMPTY_STRING = "";
    public static final String FOLDER_NAME_PREFIX = "job/";
    public static final Character FOLDER_NAME_SEPARATOR = Character.valueOf('/');

    @Override
    public String apply(Object folderPath) {
        if (folderPath == null) {
            return EMPTY_STRING;
        }
        StringBuilder path = new StringBuilder((String)folderPath);
        if (path.length() == 0) {
            return EMPTY_STRING;
        }
        if (path.charAt(0) == FOLDER_NAME_SEPARATOR.charValue()) {
            path.deleteCharAt(0);
        }
        if (path.length() == 0) {
            return EMPTY_STRING;
        }
        if (path.charAt(path.length() - 1) == FOLDER_NAME_SEPARATOR.charValue()) {
            path.deleteCharAt(path.length() - 1);
        }
        if (path.length() == 0) {
            return EMPTY_STRING;
        }
        String[] folders = path.toString().split(Character.toString(FOLDER_NAME_SEPARATOR.charValue()));
        path.setLength(0);
        for (String folder : folders) {
            path.append(FOLDER_NAME_PREFIX).append(folder).append(FOLDER_NAME_SEPARATOR);
        }
        return path.toString();
    }
}

