/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Lists;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Key;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.MembersInjector;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Provider;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.Errors;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.InjectorImpl;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.LookupProcessor;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.Lookups;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.Element;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.MembersInjectorLookup;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.ProviderLookup;
import java.util.List;

final class DeferredLookups
implements Lookups {
    private final InjectorImpl injector;
    private final List<Element> lookups = Lists.newArrayList();

    DeferredLookups(InjectorImpl injector) {
        this.injector = injector;
    }

    void initialize(Errors errors) {
        this.injector.lookups = this.injector;
        new LookupProcessor(errors).process(this.injector, this.lookups);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        ProviderLookup<T> lookup = new ProviderLookup<T>(key, key);
        this.lookups.add(lookup);
        return lookup.getProvider();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type) {
        MembersInjectorLookup<T> lookup = new MembersInjectorLookup<T>(type, type);
        this.lookups.add(lookup);
        return lookup.getMembersInjector();
    }
}

