/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ListMultimap;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Lists;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Maps;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Binding;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Key;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Stage;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.CycleDetectingLock;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.Errors;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.ErrorsException;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.Initializable;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.Initializables;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.InjectorImpl;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.InternalProvisionException;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.MembersInjectorImpl;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.ProvisionListenerStackCallback;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.InjectionPoint;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

final class Initializer {
    private volatile boolean validationStarted = false;
    private final CycleDetectingLock.CycleDetectingLockFactory<Class<?>> cycleDetectingLockFactory = new CycleDetectingLock.CycleDetectingLockFactory();
    private final List<InjectableReference<?>> pendingInjections = Lists.newArrayList();
    private final IdentityHashMap<Object, InjectableReference<?>> initializablesCache = Maps.newIdentityHashMap();

    Initializer() {
    }

    <T> Initializable<T> requestInjection(InjectorImpl injector, T instance, Binding<T> binding, Object source, Set<InjectionPoint> injectionPoints) {
        ProvisionListenerStackCallback<T> provisionCallback;
        Preconditions.checkNotNull(source);
        Preconditions.checkState(!this.validationStarted, "Member injection could not be requested after validation is started");
        ProvisionListenerStackCallback<T> provisionListenerStackCallback = provisionCallback = binding == null ? null : injector.provisionListenerStore.get(binding);
        if (instance == null || injectionPoints.isEmpty() && !injector.membersInjectorStore.hasTypeListeners() && provisionCallback == null) {
            return Initializables.of(instance);
        }
        if (this.initializablesCache.containsKey(instance)) {
            Initializable cached = this.initializablesCache.get(instance);
            return cached;
        }
        InjectableReference<T> injectableReference = new InjectableReference<T>(injector, instance, binding == null ? null : binding.getKey(), provisionCallback, source, this.cycleDetectingLockFactory.create(instance.getClass()));
        this.initializablesCache.put(instance, injectableReference);
        this.pendingInjections.add(injectableReference);
        return injectableReference;
    }

    void validateOustandingInjections(Errors errors) {
        this.validationStarted = true;
        this.initializablesCache.clear();
        for (InjectableReference<?> reference : this.pendingInjections) {
            try {
                reference.validate(errors);
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
        }
    }

    void injectAll(Errors errors) {
        Preconditions.checkState(this.validationStarted, "Validation should be done before injection");
        for (InjectableReference<?> reference : this.pendingInjections) {
            try {
                reference.get();
            }
            catch (InternalProvisionException ipe) {
                errors.merge(ipe);
            }
        }
        this.pendingInjections.clear();
    }

    private static class InjectableReference<T>
    implements Initializable<T> {
        private volatile InjectableReferenceState state = InjectableReferenceState.NEW;
        private volatile MembersInjectorImpl<T> membersInjector = null;
        private final InjectorImpl injector;
        private final T instance;
        private final Object source;
        private final Key<T> key;
        private final ProvisionListenerStackCallback<T> provisionCallback;
        private final CycleDetectingLock<?> lock;

        public InjectableReference(InjectorImpl injector, T instance, Key<T> key, ProvisionListenerStackCallback<T> provisionCallback, Object source, CycleDetectingLock<?> lock) {
            this.injector = injector;
            this.key = key;
            this.provisionCallback = provisionCallback;
            this.instance = Preconditions.checkNotNull(instance, "instance");
            this.source = Preconditions.checkNotNull(source, "source");
            this.lock = Preconditions.checkNotNull(lock, "lock");
        }

        public void validate(Errors errors) throws ErrorsException {
            TypeLiteral<?> type = TypeLiteral.get(this.instance.getClass());
            this.membersInjector = this.injector.membersInjectorStore.get(type, errors.withSource(this.source));
            Preconditions.checkNotNull(this.membersInjector, "No membersInjector available for instance: %s, from key: %s", this.instance, this.key);
            this.state = InjectableReferenceState.VALIDATED;
        }

        @Override
        public T get() throws InternalProvisionException {
            if (this.state == InjectableReferenceState.READY) {
                return this.instance;
            }
            ListMultimap<Thread, ?> lockCycle = this.lock.lockOrDetectPotentialLocksCycle();
            if (!lockCycle.isEmpty()) {
                return this.instance;
            }
            try {
                switch (this.state) {
                    case READY: {
                        T t = this.instance;
                        return t;
                    }
                    case INJECTING: {
                        T t = this.instance;
                        return t;
                    }
                    case VALIDATED: {
                        this.state = InjectableReferenceState.INJECTING;
                        break;
                    }
                    case NEW: {
                        throw new IllegalStateException("InjectableReference is not validated yet");
                    }
                    default: {
                        throw new IllegalStateException("Unknown state: " + (Object)((Object)this.state));
                    }
                }
                try {
                    this.membersInjector.injectAndNotify(this.instance, this.key, this.provisionCallback, this.source, this.injector.options.stage == Stage.TOOL);
                }
                catch (InternalProvisionException ipe) {
                    throw ipe.addSource(this.source);
                }
                this.state = InjectableReferenceState.READY;
                T t = this.instance;
                return t;
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return this.instance.toString();
        }
    }

    private static enum InjectableReferenceState {
        NEW,
        VALIDATED,
        INJECTING,
        READY;

    }
}

