/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.com.google.inject.internal.util;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Stopwatch;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.concurrent.NotThreadSafe;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

@NotThreadSafe
public final class ContinuousStopwatch {
    private final Logger logger = Logger.getLogger(ContinuousStopwatch.class.getName());
    private final Stopwatch stopwatch;

    public ContinuousStopwatch(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
        this.reset();
    }

    public long reset() {
        long elapsedTimeMs = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        this.stopwatch.reset();
        this.stopwatch.start();
        return elapsedTimeMs;
    }

    public void resetAndLog(String label) {
        this.logger.fine(label + ": " + this.reset() + "ms");
    }
}

