/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.Beta;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.MoreObjects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Objects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.AbstractIterator;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.IterableWithMarker;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.PagedIterable;
import java.util.Iterator;

@Beta
public class PagedIterables {
    public static <T> PagedIterable<T> onlyPage(final IterableWithMarker<T> only) {
        return new PagedIterable<T>(){

            @Override
            public Iterator<IterableWithMarker<T>> iterator() {
                return ImmutableSet.of(only).iterator();
            }
        };
    }

    @Deprecated
    public static <T> PagedIterable<T> of(IterableWithMarker<T> only) {
        return PagedIterables.onlyPage(only);
    }

    public static <T> PagedIterable<T> advance(final IterableWithMarker<T> initial, final Function<Object, IterableWithMarker<T>> markerToNext) {
        return new PagedIterable<T>(){

            @Override
            public Iterator<IterableWithMarker<T>> iterator() {
                return PagedIterables.advancingIterator(initial, markerToNext);
            }
        };
    }

    private static <T> Iterator<IterableWithMarker<T>> advancingIterator(IterableWithMarker<T> initial, Function<Object, IterableWithMarker<T>> markerToNext) {
        if (!initial.nextMarker().isPresent()) {
            return ImmutableSet.of(initial).iterator();
        }
        return new AdvancingIterator(initial, markerToNext);
    }

    private static class AdvancingIterator<T>
    extends AbstractIterator<IterableWithMarker<T>> {
        private final Function<Object, IterableWithMarker<T>> markerToNext;
        private transient IterableWithMarker<T> current;
        private transient boolean unread = true;

        private AdvancingIterator(IterableWithMarker<T> initial, Function<Object, IterableWithMarker<T>> markerToNext) {
            this.current = Preconditions.checkNotNull(initial, "initial iterable");
            this.markerToNext = Preconditions.checkNotNull(markerToNext, "marker to next iterable");
        }

        @Override
        protected IterableWithMarker<T> computeNext() {
            if (this.unread) {
                try {
                    IterableWithMarker<T> iterableWithMarker = this.current;
                    return iterableWithMarker;
                }
                finally {
                    this.unread = false;
                }
            }
            if (this.current.nextMarker().isPresent()) {
                this.current = this.markerToNext.apply(this.current.nextMarker().get());
                return this.current;
            }
            return (IterableWithMarker)this.endOfData();
        }

        public int hashCode() {
            return Objects.hashCode(this.current, this.unread);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AdvancingIterator other = (AdvancingIterator)AdvancingIterator.class.cast(obj);
            return Objects.equal(this.current, other.current) && Objects.equal(this.unread, other.unread);
        }

        public String toString() {
            return MoreObjects.toStringHelper("").add("current", this.current).add("unread", this.unread).toString();
        }
    }
}

