/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.concurrent.config;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.MoreExecutors;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.AbstractModule;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Provides;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.concurrent.config.ExecutorServiceModule;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.concurrent.config.WithSubmissionTrace;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.lifecycle.Closer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class ScheduledExecutorServiceModule
extends AbstractModule {
    @Provides
    @Singleton
    @Named(value="jclouds.scheduler-threads")
    final ListeningScheduledExecutorService provideListeningScheduledExecutorService(@Named(value="jclouds.scheduler-threads") int count, Closer closer) {
        return ExecutorServiceModule.shutdownOnClose(WithSubmissionTrace.wrap(ScheduledExecutorServiceModule.newScheduledThreadPoolNamed("scheduler thread %d", count)), closer);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.scheduler-threads")
    final ScheduledExecutorService provideScheduledExecutor(@Named(value="jclouds.scheduler-threads") ListeningScheduledExecutorService in) {
        return in;
    }

    private static ListeningScheduledExecutorService newScheduledThreadPoolNamed(String name, int maxCount) {
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat(name).setThreadFactory(Executors.defaultThreadFactory()).build();
        return MoreExecutors.listeningDecorator(maxCount == 0 ? Executors.newSingleThreadScheduledExecutor(factory) : Executors.newScheduledThreadPool(maxCount, factory));
    }

    @Override
    protected void configure() {
    }
}

