/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.crypto;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.Beta;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Optional;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicates;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableCollection;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableList;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterators;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.io.ByteStreams;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.primitives.Bytes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Iterator;
import java.util.List;

@Beta
final class ASN1Codec {
    private static final int TAG = 2;
    private static final int CONSTRUCTED = 32;
    private static final int INTEGER = 2;
    private static final int BIT_STRING = 3;
    private static final int SEQUENCE = 16;

    private ASN1Codec() {
    }

    static RSAPublicKeySpec decodeRSAPublicKey(byte[] bytes) {
        List seq = ASN1Codec.createASN1Sequence(bytes);
        Preconditions.checkArgument(seq.size() == 2, "expected 2 components of ASN1Sequence: %s", seq);
        if (seq.get(1) instanceof List) {
            seq = (List)List.class.cast(seq.get(1));
        }
        return new RSAPublicKeySpec(ASN1Codec.bigIntAt(seq, 0), ASN1Codec.bigIntAt(seq, 1));
    }

    static RSAPrivateCrtKeySpec decodeRSAPrivateKey(byte[] bytes) {
        List<Object> seq = ASN1Codec.createASN1Sequence(bytes);
        Preconditions.checkArgument(seq.size() >= 9, "not enough elements (%s) for a private key", seq.size(), seq);
        int version = ASN1Codec.bigIntAt(seq, 0).intValue();
        Preconditions.checkArgument(version == 0 || version == 1, "wrong version %s for RSA private key", version);
        return new RSAPrivateCrtKeySpec(ASN1Codec.bigIntAt(seq, 1), ASN1Codec.bigIntAt(seq, 2), ASN1Codec.bigIntAt(seq, 3), ASN1Codec.bigIntAt(seq, 4), ASN1Codec.bigIntAt(seq, 5), ASN1Codec.bigIntAt(seq, 6), ASN1Codec.bigIntAt(seq, 7), ASN1Codec.bigIntAt(seq, 8));
    }

    private static BigInteger bigIntAt(List<Object> seq, int index) {
        return (BigInteger)BigInteger.class.cast(seq.get(index));
    }

    private static List<Object> createASN1Sequence(byte[] input) {
        Object out = ASN1Codec.create(new ByteArrayInputStream(input), input.length).get();
        Preconditions.checkArgument(out instanceof List, "expected List not %s", out);
        return (List)List.class.cast(out);
    }

    private static Optional<Object> buildObject(int tag, int tagNo, InputStream in, int limit) {
        boolean isConstructed = (tag & 0x20) != 0;
        InputStream limited = ByteStreams.limit(in, limit);
        if (isConstructed && tagNo == 16) {
            return Optional.of(ASN1Codec.buildEncodableList(limited, limit));
        }
        byte[] bytes = ASN1Codec.toArray(limited);
        switch (tagNo) {
            case 3: {
                return Optional.of(ASN1Codec.nestedASN1Sequence(bytes));
            }
            case 2: {
                return Optional.of(new BigInteger(bytes));
            }
        }
        return Optional.absent();
    }

    private static List<Object> nestedASN1Sequence(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 1, "truncated BIT_STRING detected");
        byte[] data = new byte[bytes.length - 1];
        System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
        return ASN1Codec.createASN1Sequence(data);
    }

    private static List<Object> buildEncodableList(final InputStream in, final int limit) {
        return ImmutableList.copyOf(Iterators.filter(new Iterator<Object>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Object next() {
                int tag = ASN1Codec.read(in);
                if (tag == -1) {
                    this.hasNext = false;
                    return null;
                }
                Preconditions.checkArgument(tag != 0, "invalid tag %s", tag);
                int tagNo = tag & 0x1F;
                int length = ASN1Codec.readLength(in, limit);
                Preconditions.checkArgument(length >= 0, "indefinite length not supported");
                return ASN1Codec.buildObject(tag, tagNo, in, length).orNull();
            }

            @Override
            public void remove() {
            }
        }, Predicates.notNull()));
    }

    private static Optional<Object> create(InputStream in, int limit) {
        int tag = ASN1Codec.read(in);
        if (tag == -1) {
            return Optional.absent();
        }
        Preconditions.checkArgument(tag != 0, "invalid tag %s", tag);
        int tagNo = tag & 0x1F;
        int length = ASN1Codec.readLength(in, limit);
        Preconditions.checkArgument(length >= 0, "indefinite length not supported");
        return ASN1Codec.buildObject(tag, tagNo, in, length);
    }

    private static int readLength(InputStream s2, int limit) {
        int length = ASN1Codec.read(s2);
        Preconditions.checkArgument(length >= 0, "EOF found when length expected");
        Preconditions.checkArgument(length != 128, "indefinite-length encoding not supported");
        if (length > 127) {
            int size = length & 0x7F;
            Preconditions.checkArgument(size <= 4, "DER length more than 4 bytes: %s", size);
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = ASN1Codec.read(s2);
                Preconditions.checkArgument(next >= 0, "EOF found reading length");
                length = (length << 8) + next;
            }
            Preconditions.checkArgument(length >= 0, "corrupted stream - negative length %s found", length);
            Preconditions.checkArgument(length < limit, "corrupted stream - length %s out of bounds %s", length, limit);
        }
        return length;
    }

    private static int read(InputStream s2) {
        try {
            return s2.read();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private static byte[] toArray(InputStream limited) {
        try {
            return ByteStreams.toByteArray(limited);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    static byte[] encode(RSAPrivateCrtKey key) {
        ImmutableCollection seq = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(BigInteger.valueOf(0L))).add(key.getModulus())).add(key.getPublicExponent())).add(key.getPrivateExponent())).add(key.getPrimeP())).add(key.getPrimeQ())).add(key.getPrimeExponentP())).add(key.getPrimeExponentQ())).add(key.getCrtCoefficient())).build();
        int length = 0;
        for (BigInteger part : seq) {
            byte[] bytes = part.toByteArray();
            length += 1 + ASN1Codec.calculateBodyLength(bytes.length) + bytes.length;
        }
        ImmutableList.Builder<Byte> output = ImmutableList.builder();
        output.add((Object)48);
        ASN1Codec.writeLength(output, length);
        for (BigInteger part : seq) {
            byte[] bytes = part.toByteArray();
            output.add((Object)2);
            ASN1Codec.writeLength(output, bytes.length);
            output.addAll(Bytes.asList(bytes));
        }
        return Bytes.toArray(output.build());
    }

    private static void writeLength(ImmutableList.Builder<Byte> output, int length) {
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            output.add((Object)((byte)(size | 0x80)));
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                output.add((Object)((byte)(length >> i)));
            }
        } else {
            output.add((Object)((byte)length));
        }
    }

    private static int calculateBodyLength(int length) {
        int count = 1;
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                ++count;
            }
        }
        return count;
    }
}

