/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.internal;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.MoreObjects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Objects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Maps;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Location;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.MutableResourceMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.ResourceMetadata;
import java.net.URI;
import java.util.Map;

public class MutableResourceMetadataImpl<T extends Enum<T>>
implements MutableResourceMetadata<T> {
    private T type;
    private String id;
    private String name;
    private Location location;
    private URI uri;
    private Map<String, String> userMetadata;

    public MutableResourceMetadataImpl() {
        this.userMetadata = Maps.newLinkedHashMap();
    }

    public MutableResourceMetadataImpl(ResourceMetadata<T> from) {
        this.type = from.getType();
        this.id = from.getProviderId();
        this.name = from.getName();
        this.location = from.getLocation();
        this.uri = from.getUri();
        this.userMetadata = from.getUserMetadata();
    }

    @Override
    public int compareTo(ResourceMetadata<T> o) {
        if (this.getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProviderId() {
        return this.id;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setType(T type) {
        this.type = type;
    }

    @Override
    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").omitNullValues().add("id", this.id).add("location", this.location).add("name", this.name).add("type", this.getType()).add("uri", this.uri).add("userMetadata", this.userMetadata);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.location, this.name, this.type, this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutableResourceMetadata)) {
            return false;
        }
        MutableResourceMetadata other = (MutableResourceMetadata)obj;
        return Objects.equal(this.id, other.getProviderId()) && Objects.equal(this.location, other.getLocation()) && Objects.equal(this.name, other.getName()) && Objects.equal(this.type, other.getType()) && Objects.equal(this.uri, other.getUri());
    }
}

