/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Objects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.internal.GeneratedHttpRequest;

public class HttpCommand {
    private volatile HttpRequest request;
    private volatile int failureCount;
    private volatile int redirectCount;
    private volatile Exception exception;

    public HttpCommand(HttpRequest request) {
        this.request = Preconditions.checkNotNull(request, "request");
        this.failureCount = 0;
        this.redirectCount = 0;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public int incrementFailureCount() {
        return ++this.failureCount;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }

    public int incrementRedirectCount() {
        return ++this.redirectCount;
    }

    public int getRedirectCount() {
        return this.redirectCount;
    }

    public boolean isReplayable() {
        return this.request.getPayload() == null ? true : this.request.getPayload().isRepeatable();
    }

    public HttpRequest getCurrentRequest() {
        return this.request;
    }

    public void setCurrentRequest(HttpRequest request) {
        this.request = request;
    }

    public int hashCode() {
        return Objects.hashCode(this.request);
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (!(that instanceof HttpCommand)) {
            return false;
        }
        return Objects.equal(this.request, ((HttpCommand)HttpCommand.class.cast(that)).getCurrentRequest());
    }

    public String toString() {
        if (this.request instanceof GeneratedHttpRequest) {
            GeneratedHttpRequest gRequest = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(this.request);
            return String.format("[method=%s, request=%s]", gRequest.getInvocation(), gRequest.getRequestLine());
        }
        return "[request=" + this.request.getRequestLine() + "]";
    }
}

