/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.MoreObjects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Objects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Multimap;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpMessage;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.io.Payload;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.javax.annotation.Nullable;

public class HttpResponse
extends HttpMessage {
    private final int statusCode;
    private final String message;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHttpResponse(this);
    }

    protected HttpResponse(int statusCode, @Nullable String message, Multimap<String, String> headers, @Nullable Payload payload) {
        super(headers, payload);
        this.statusCode = statusCode;
        this.message = message;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public String getStatusLine() {
        return String.format("HTTP/1.1 %d %s", this.getStatusCode(), this.getMessage());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.statusCode, this.message, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpResponse)) {
            return false;
        }
        HttpResponse that = (HttpResponse)HttpResponse.class.cast(obj);
        return super.equals(that) && Objects.equal(this.statusCode, that.statusCode) && Objects.equal(this.message, that.message);
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").omitNullValues().add("statusCode", this.statusCode).add("message", this.message).add("headers", this.headers).add("payload", this.payload);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends HttpMessage.Builder<T> {
        protected int statusCode;
        protected String message;

        public T statusCode(int statusCode) {
            this.statusCode = statusCode;
            return (T)((Builder)this.self());
        }

        public T message(@Nullable String message) {
            this.message = message;
            return (T)((Builder)this.self());
        }

        @Override
        public HttpResponse build() {
            return new HttpResponse(this.statusCode, this.message, this.headers.build(), this.payload);
        }

        public T fromHttpResponse(HttpResponse in) {
            return ((Builder)((Builder)super.fromHttpMessage(in)).statusCode(in.getStatusCode())).message(in.getMessage());
        }
    }
}

