/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponseException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpUtils;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.json.Json;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

@Singleton
public class ParseJson<T>
implements Function<HttpResponse, T> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Json json;
    protected final TypeLiteral<T> type;

    @Inject
    public ParseJson(Json json, TypeLiteral<T> type) {
        this.json = json;
        this.type = type;
    }

    @Override
    public T apply(HttpResponse from) {
        try {
            InputStream gson = from.getPayload().openStream();
            T t = this.apply(gson);
            return t;
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder();
            message.append("Error parsing input: ");
            message.append(e.getMessage());
            this.logger.error(e, message.toString(), new Object[0]);
            throw new HttpResponseException(message.toString() + "\n" + from, null, from, (Throwable)e);
        }
        finally {
            HttpUtils.releasePayload(from);
        }
    }

    @Override
    public T apply(InputStream stream) throws IOException {
        return (T)this.apply(stream, this.type.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V apply(InputStream stream, Type type) throws IOException {
        try {
            Object t = this.json.fromJson(stream, StandardCharsets.UTF_8, type);
            return (V)t;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

