/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpUtils;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Strings2;
import java.io.IOException;
import java.io.InputStream;

@Singleton
public class ReturnStringIf2xx
implements Function<HttpResponse, String> {
    @Override
    public String apply(HttpResponse from) {
        if (from.getPayload() == null) {
            return null;
        }
        try {
            if (from.getStatusCode() >= 200) {
                InputStream payload = from.getPayload().getInput();
                String toReturn = null;
                try {
                    toReturn = Strings2.toStringAndClose(payload);
                }
                catch (IOException e) {
                    throw new HttpException(String.format("Couldn't receive response %1$s, payload: %2$s ", from, toReturn), e);
                }
                String string = toReturn;
                return string;
            }
            throw new HttpException(String.format("Unhandled status code  - %1$s", from));
        }
        finally {
            HttpUtils.releasePayload(from);
        }
    }
}

