/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.json.internal;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ForwardingObject;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.Gson;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.json.Json;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

@Singleton
public class GsonWrapper
extends ForwardingObject
implements Json {
    private final Gson gson;

    @Inject
    public GsonWrapper(Gson gson) {
        this.gson = gson;
    }

    @Override
    public <T> T fromJson(String json, Type type) {
        return this.gson.fromJson(json, type);
    }

    @Override
    public <T> T fromJson(String json, Class<T> classOfT) {
        return this.gson.fromJson(json, classOfT);
    }

    @Override
    public <T> T fromJson(InputStream json, Charset charset, Type type) {
        return this.gson.fromJson((Reader)new InputStreamReader(json, charset), type);
    }

    @Override
    public <T> T fromJson(InputStream json, Charset charset, Class<T> classOfT) {
        return this.gson.fromJson((Reader)new InputStreamReader(json, charset), classOfT);
    }

    @Override
    public String toJson(Object src) {
        return this.gson.toJson(src);
    }

    @Override
    public String toJson(Object src, Type type) {
        return this.gson.toJson(src, type);
    }

    @Override
    public Gson delegate() {
        return this.gson;
    }
}

