/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.lifecycle;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Lists;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.Atomics;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@Singleton
public class Closer
implements Closeable {
    List<Closeable> methodsToClose = Lists.newArrayList();
    private final AtomicReference<State> state = Atomics.newReference(State.AVAILABLE);

    public void addToClose(Closeable toClose) {
        this.methodsToClose.add(toClose);
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.AVAILABLE, State.PROCESSING)) {
            Collections.reverse(this.methodsToClose);
            for (Closeable toClose : this.methodsToClose) {
                toClose.close();
            }
            this.state.set(State.DONE);
        }
    }

    public State getState() {
        return this.state.get();
    }

    public static enum State {
        AVAILABLE,
        PROCESSING,
        DONE;

    }
}

