/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.config;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Optional;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Suppliers;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Sets;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.AbstractModule;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Provides;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.Memoized;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Location;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Iso3166;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Provider;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Region;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Zone;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.predicates.RegionIdFilter;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.predicates.ZoneIdFilter;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.ImplicitLocationSupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.ImplicitRegionIdSupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.LocationIdToIso3166CodesSupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.LocationsSupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.ProviderURISupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.RegionIdToURISupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.RegionIdToZoneIdsSupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.RegionIdsSupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.ZoneIdToURISupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.ZoneIdsSupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.reflect.InvocationSuccess;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.AuthorizationException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.functions.ImplicitOptionalConverter;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class LocationModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(new TypeLiteral<Function<InvocationSuccess, Optional<Object>>>(){}).to(ImplicitOptionalConverter.class);
    }

    @Provides
    @Singleton
    @Iso3166
    protected final Supplier<Map<String, Supplier<Set<String>>>> isoCodesSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, LocationIdToIso3166CodesSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Provider
    protected final Supplier<URI> provideProvider(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, ProviderURISupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected final Supplier<Location> implicitLocationSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, ImplicitLocationSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Memoized
    protected final Supplier<Set<? extends Location>> memoizedLocationsSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, LocationsSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Region
    protected final Supplier<Set<String>> regionIdsSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, RegionIdFilter filter, RegionIdsSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, Suppliers.compose(new FilterStrings(filter), uncached), seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Zone
    protected final Supplier<Set<String>> zoneIdsSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, ZoneIdFilter filter, ZoneIdsSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, Suppliers.compose(new FilterStrings(filter), uncached), seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Region
    protected final Supplier<Map<String, Supplier<URI>>> regionIdToURISupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, RegionIdToURISupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Region
    protected final Supplier<String> implicitRegionIdSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, ImplicitRegionIdSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Zone
    protected final Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIdsSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, RegionIdToZoneIdsSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Zone
    protected final Supplier<Map<String, Supplier<URI>>> zoneIdToURISupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, ZoneIdToURISupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    static class FilterStrings
    implements Function<Set<String>, Set<String>> {
        public final Predicate<String> filter;

        public FilterStrings(Predicate<String> filter) {
            this.filter = Preconditions.checkNotNull(filter, "filter");
        }

        @Override
        public Set<String> apply(Set<String> input) {
            return Sets.filter(input, this.filter);
        }

        public String toString() {
            return "filterStrings(" + this.filter + ")";
        }
    }
}

