/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Region;
import java.net.URI;
import java.util.Map;

public final class RegionToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> regionToEndpoints;

    @Inject
    RegionToEndpoint(@Region Supplier<Map<String, Supplier<URI>>> regionToEndpoints) {
        this.regionToEndpoints = regionToEndpoints;
    }

    @Override
    public URI apply(Object from) {
        Map<String, Supplier<URI>> regionToEndpoint = this.regionToEndpoints.get();
        Preconditions.checkState(!regionToEndpoint.isEmpty(), "no region name to endpoint mappings configured!");
        Preconditions.checkArgument(regionToEndpoint.containsKey(from), "requested location %s, which is not a configured region: %s", from, regionToEndpoint);
        return regionToEndpoint.get(from).get();
    }
}

