/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.jdk;

import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.BaseLogger;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import java.util.logging.Level;

public class JDKLogger
extends BaseLogger {
    private final java.util.logging.Logger logger;

    public JDKLogger(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    @Override
    protected void logTrace(String message) {
        this.logger.finest(message);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    protected void logDebug(String message) {
        this.logger.fine(message);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    protected void logInfo(String message) {
        this.logger.info(message);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    protected void logWarn(String message) {
        this.logger.warning(message);
    }

    @Override
    protected void logWarn(String message, Throwable e) {
        this.logger.log(Level.WARNING, message, e);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    protected void logError(String message) {
        this.logger.severe(message);
    }

    @Override
    protected void logError(String message, Throwable e) {
        this.logger.log(Level.SEVERE, message, e);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public String getCategory() {
        return this.logger.getName();
    }

    public static class JDKLoggerFactory
    implements Logger.LoggerFactory {
        @Override
        public Logger getLogger(String category) {
            return new JDKLogger(java.util.logging.Logger.getLogger(category));
        }
    }
}

