/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.osgi;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicates;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Splitter;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.FluentIterable;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Strings2;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.osgi.framework.Bundle;

public final class Bundles {
    private Bundles() {
    }

    public static <T> ImmutableSet<T> instantiateAvailableClasses(Bundle bundle, Iterable<String> classNames, Class<T> type) {
        Preconditions.checkNotNull(bundle, "bundle");
        Preconditions.checkNotNull(classNames, "classNames");
        Preconditions.checkNotNull(type, "type");
        return FluentIterable.from(classNames).transform(Bundles.loadClassIfAssignableFrom(bundle, type)).filter(Predicates.notNull()).transform(Bundles.instantiateIfPossible(type)).filter(Predicates.notNull()).toSet();
    }

    private static Function<String, Class<?>> loadClassIfAssignableFrom(final Bundle bundle, final Class<?> clazz) {
        Preconditions.checkNotNull(bundle, "bundle");
        Preconditions.checkNotNull(clazz, "clazz");
        return new Function<String, Class<?>>(){

            @Override
            public Class<?> apply(String in) {
                Preconditions.checkNotNull(in, "classname");
                try {
                    Class thing = bundle.loadClass(in);
                    if (clazz.isAssignableFrom(thing)) {
                        return thing.asSubclass(clazz);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    private static <T> Function<Class<?>, T> instantiateIfPossible(final Class<T> clazz) {
        return new Function<Class<?>, T>(){

            @Override
            public T apply(Class<?> in) {
                Preconditions.checkNotNull(in, "input class");
                try {
                    return clazz.cast(in.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    public static ImmutableSet<String> stringsForResourceInBundle(String resourcePath, Bundle bundle) {
        Preconditions.checkNotNull(resourcePath, "resourcePath");
        Preconditions.checkNotNull(bundle, "bundle");
        URL resource = bundle.getEntry(resourcePath);
        if (resource == null) {
            return ImmutableSet.of();
        }
        try {
            return ImmutableSet.copyOf(Bundles.splitOrEmptyAndClose(resource.openStream()));
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return ImmutableSet.of();
    }

    private static Iterable<String> splitOrEmptyAndClose(InputStream in) throws IOException {
        return Splitter.onPattern("\r?\n").omitEmptyStrings().split(Strings2.toStringAndClose(in));
    }
}

