/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.predicates;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.VisibleForTesting;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.net.HostAndPort;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.predicates.SocketOpen;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;

@Singleton
public class InetSocketAddressConnect
implements SocketOpen {
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="io.github.cdancy.jenkins.rest.shaded.org.jclouds.socket_timeout")
    private int timeout = 2000;
    private final Function<URI, Proxy> proxyForURI;

    @Inject
    @VisibleForTesting
    InetSocketAddressConnect(Function<URI, Proxy> proxyForURI) {
        this.proxyForURI = Preconditions.checkNotNull(proxyForURI, "proxyForURI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(HostAndPort socketA) {
        InetSocketAddress socketAddress = new InetSocketAddress(socketA.getHost(), socketA.getPort());
        Socket socket = null;
        try {
            this.logger.trace("testing socket %s", socketAddress);
            socket = new Socket(this.proxyForURI.apply(URI.create("socket://" + socketA.getHost() + ":" + socketA.getPort())));
            socket.setReuseAddress(false);
            socket.setSoLinger(false, 1);
            socket.setSoTimeout(this.timeout);
            socket.connect(socketAddress, this.timeout);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }
}

