/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.providers.config;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.TypeToken;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.AbstractModule;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Injector;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Key;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Provides;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.name.Names;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.util.Providers;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.Context;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Credentials;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Iso3166;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Provider;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.providers.ProviderMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.Api;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.ApiVersion;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.BuildVersion;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BindProviderMetadataContextAndCredentials
extends AbstractModule {
    private final ProviderMetadata providerMetadata;
    private final Supplier<Credentials> creds;

    public BindProviderMetadataContextAndCredentials(ProviderMetadata providerMetadata, Supplier<Credentials> creds) {
        this.providerMetadata = Preconditions.checkNotNull(providerMetadata, "providerMetadata");
        this.creds = Preconditions.checkNotNull(creds, "creds");
    }

    @Override
    protected void configure() {
        this.bind(ProviderMetadata.class).toInstance(this.providerMetadata);
        Properties toBind = new Properties();
        toBind.putAll((Map<?, ?>)this.providerMetadata.getApiMetadata().getDefaultProperties());
        toBind.putAll((Map<?, ?>)this.providerMetadata.getDefaultProperties());
        Names.bindProperties(this.binder(), toBind);
        this.bind(new TypeLiteral<Supplier<Credentials>>(){}).annotatedWith(Provider.class).toInstance(this.creds);
        this.bindConstant().annotatedWith(Provider.class).to(this.providerMetadata.getId());
        this.bind(new TypeLiteral<Set<String>>(){}).annotatedWith(Iso3166.class).toInstance(this.providerMetadata.getIso3166Codes());
        this.bindConstant().annotatedWith(Api.class).to(this.providerMetadata.getApiMetadata().getId());
        this.bindConstant().annotatedWith(ApiVersion.class).to(this.providerMetadata.getApiMetadata().getVersion());
        this.bind(String.class).annotatedWith(BuildVersion.class).toProvider(Providers.of(this.providerMetadata.getApiMetadata().getBuildVersion().orNull()));
        this.bind(new TypeLiteral<TypeToken<? extends Context>>(){}).annotatedWith(Provider.class).toInstance(this.providerMetadata.getApiMetadata().getContext());
    }

    @Provides
    @Provider
    @Singleton
    protected Context backend(Injector i, @Provider TypeToken<? extends Context> backendType) {
        return (Context)Context.class.cast(i.getInstance(Key.get(TypeLiteral.get(backendType.getType()))));
    }
}

