/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.proxy;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.VisibleForTesting;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Optional;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Credentials;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.proxy.ProxyConfig;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;

@Singleton
public class ProxyForURI
implements Function<URI, Proxy> {
    private final ProxyConfig config;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-for-sockets")
    private boolean useProxyForSockets = true;

    @Inject
    @VisibleForTesting
    ProxyForURI(ProxyConfig config) {
        this.config = Preconditions.checkNotNull(config, "config");
    }

    @Override
    public Proxy apply(URI endpoint) {
        if (!this.useProxyForSockets && "socket".equals(endpoint.getScheme())) {
            return Proxy.NO_PROXY;
        }
        if (this.config.getProxy().isPresent()) {
            InetSocketAddress addr = new InetSocketAddress(this.config.getProxy().get().getHost(), this.config.getProxy().get().getPort());
            Proxy proxy = new Proxy(this.config.getType(), addr);
            final Optional<Credentials> creds = this.config.getCredentials();
            if (creds.isPresent()) {
                Authenticator authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(((Credentials)creds.get()).identity, ((Credentials)creds.get()).credential.toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
            return proxy;
        }
        if (this.config.isJvmProxyEnabled()) {
            return this.getDefaultProxy(endpoint);
        }
        if (this.config.useSystem()) {
            System.setProperty("java.net.useSystemProxies", "true");
            return this.getDefaultProxy(endpoint);
        }
        return Proxy.NO_PROXY;
    }

    private Proxy getDefaultProxy(URI endpoint) {
        List<Proxy> proxies = ProxySelector.getDefault().select(endpoint);
        return Iterables.getLast(proxies);
    }
}

