/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.binders;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.net.InternetDomainName;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.Uris;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.Binder;
import java.net.URI;

@Singleton
public class BindAsHostPrefix
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkNotNull(payload, "hostprefix");
        Preconditions.checkArgument(InternetDomainName.isValid(request.getEndpoint().getHost()), "this is only valid for hostnames: " + request);
        InternetDomainName name = InternetDomainName.from(request.getEndpoint().getHost()).child(payload.toString());
        URI newEndpoint = Uris.uriBuilder(request.getEndpoint()).host(name.toString()).build();
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(newEndpoint)).replacePath(request.getEndpoint().getRawPath())).build();
    }
}

