/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.config;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.Beta;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Charsets;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.io.ByteSource;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.AbstractModule;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Provides;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.collect.TransformingMap;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Credentials;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.json.Json;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.ConfiguresCredentialStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ConfiguresCredentialStore
@Beta
public class CredentialStoreModule
extends AbstractModule {
    private final Map<String, ByteSource> backing;

    public CredentialStoreModule(Map<String, ByteSource> backing) {
        this.backing = backing;
    }

    public CredentialStoreModule() {
        this(new ConcurrentHashMap<String, ByteSource>());
    }

    @Override
    protected void configure() {
        this.bind(new TypeLiteral<Function<Credentials, ByteSource>>(){}).to(CredentialsToJsonByteSource.class);
        this.bind(new TypeLiteral<Function<ByteSource, Credentials>>(){}).to(CredentialsFromJsonByteSource.class);
        this.bind(new TypeLiteral<Map<String, ByteSource>>(){}).toInstance(this.backing);
    }

    @Provides
    @Singleton
    protected final Map<String, Credentials> provideCredentialStore(Map<String, ByteSource> backing, Function<Credentials, ByteSource> credentialsSerializer, Function<ByteSource, Credentials> credentialsDeserializer) {
        return new TransformingMap<String, ByteSource, Credentials>(backing, credentialsDeserializer, credentialsSerializer);
    }

    public static class CredentialsFromJsonByteSource
    implements Function<ByteSource, Credentials> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final Json json;

        @Inject
        CredentialsFromJsonByteSource(Json json) {
            this.json = json;
        }

        @Override
        public Credentials apply(ByteSource from) {
            try {
                String creds = Preconditions.checkNotNull(from).asCharSource(Charsets.UTF_8).read();
                return this.json.fromJson(creds, Credentials.class);
            }
            catch (Exception e) {
                this.logger.warn(e, "ignoring problem retrieving credentials", new Object[0]);
                return null;
            }
        }
    }

    public static class CredentialsToJsonByteSource
    implements Function<Credentials, ByteSource> {
        private final Json json;

        @Inject
        CredentialsToJsonByteSource(Json json) {
            this.json = json;
        }

        @Override
        public ByteSource apply(Credentials from) {
            Preconditions.checkNotNull(from, "inputCredentials");
            return ByteSource.wrap(this.json.toJson(from).getBytes(Charsets.UTF_8));
        }
    }
}

