/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.config;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.Beta;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Optional;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Maps;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.Invokable;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Injector;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.Fallback;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.reflect.Invocation;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.config.InvocationConfig;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Maps2;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Predicates2;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

@Singleton
@Beta
public class ReadAnnotationsAndProperties
implements InvocationConfig {
    private final Injector injector;
    private final Fallback<Object> defaultFallback;
    private final Map<String, Long> timeouts;

    @Inject
    ReadAnnotationsAndProperties(Injector injector, Function<Predicate<String>, Map<String, String>> filterStringsBoundByName, Fallback<Object> defaultFallback) {
        this.injector = injector;
        this.defaultFallback = defaultFallback;
        this.timeouts = ReadAnnotationsAndProperties.timeouts(filterStringsBoundByName);
    }

    @Override
    public Optional<Long> getTimeoutNanos(Invocation in) {
        String commandName = this.getCommandName(in);
        Optional<Long> defaultMillis = Optional.fromNullable(this.timeouts.get("default"));
        Optional<Long> timeoutMillis = Optional.fromNullable(this.timeouts.get(commandName));
        Invokable<?, ?> invoked = in.getInvokable();
        if (invoked.isAnnotationPresent(Named.class)) {
            timeoutMillis = timeoutMillis.or(defaultMillis);
        } else {
            String className = invoked.getOwnerType().getRawType().getSimpleName();
            timeoutMillis = timeoutMillis.or(Optional.fromNullable(this.timeouts.get(className))).or(defaultMillis);
        }
        if (timeoutMillis.isPresent()) {
            return Optional.of(TimeUnit.MILLISECONDS.toNanos(timeoutMillis.get()));
        }
        return Optional.absent();
    }

    @Override
    public String getCommandName(Invocation invocation) {
        Invokable<?, ?> invoked = invocation.getInvokable();
        if (invoked.isAnnotationPresent(Named.class)) {
            return invoked.getAnnotation(Named.class).value();
        }
        String className = invoked.getOwnerType().getRawType().getSimpleName();
        return className + "." + invoked.getName();
    }

    @Override
    public Fallback<?> getFallback(Invocation invocation) {
        io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.Fallback fallback = invocation.getInvokable().getAnnotation(io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.Fallback.class);
        if (fallback != null) {
            return this.injector.getInstance(fallback.value());
        }
        return this.defaultFallback;
    }

    static Map<String, Long> timeouts(Function<Predicate<String>, Map<String, String>> filterStringsBoundByName) {
        Map<String, String> stringBoundWithTimeoutPrefix = filterStringsBoundByName.apply(Predicates2.startsWith("jclouds.timeouts."));
        Map<String, Long> longsByName = Maps.transformValues(stringBoundWithTimeoutPrefix, new Function<String, Long>(){

            @Override
            public Long apply(String input) {
                return Long.valueOf(String.valueOf(input));
            }
        });
        return Maps2.transformKeys(longsByName, new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input.replaceFirst(Pattern.quote("jclouds.timeouts."), "");
            }
        });
    }
}

