/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.util;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.VisibleForTesting;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicates;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableList;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.TypeToken;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.CreationException;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.ProvisionException;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.Message;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.concurrent.TransformParallelException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponseException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.AuthorizationException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.InsufficientResourcesException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.RateLimitExceededException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.ResourceAlreadyExistsException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.ResourceNotFoundException;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public class Throwables2 {
    private static final ImmutableList<Class<? extends Throwable>> PROPAGATABLE_EXCEPTION_TYPES = ImmutableList.of(IllegalStateException.class, AssertionError.class, UnsupportedOperationException.class, IllegalArgumentException.class, AuthorizationException.class, ResourceAlreadyExistsException.class, ResourceNotFoundException.class, InsufficientResourcesException.class, RateLimitExceededException.class, ConcurrentModificationException.class, HttpResponseException.class);

    public static <T extends Throwable> Predicate<Throwable> containsThrowable(final Class<T> throwableType) {
        return new Predicate<Throwable>(){

            @Override
            public boolean apply(Throwable input) {
                return Throwables2.getFirstThrowableOfType(input, throwableType) != null;
            }

            public String toString() {
                return "containsThrowable()";
            }
        };
    }

    public static <T extends Throwable> T getFirstThrowableOfType(Throwable from, Class<T> clazz) {
        if (from instanceof ProvisionException) {
            return Throwables2.getFirstThrowableOfType((ProvisionException)ProvisionException.class.cast(from), clazz);
        }
        if (from instanceof TransformParallelException) {
            return Throwables2.getFirstThrowableOfType((TransformParallelException)TransformParallelException.class.cast(from), clazz);
        }
        if (from instanceof CreationException) {
            return Throwables2.getFirstThrowableOfType((CreationException)CreationException.class.cast(from), clazz);
        }
        try {
            return (T)((Throwable)Iterables.find(Throwables.getCausalChain(from), Predicates.instanceOf(clazz)));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @VisibleForTesting
    static <T extends Throwable> T getFirstThrowableOfType(TransformParallelException e, Class<T> clazz) {
        for (Exception exception : e.getFromToException().values()) {
            T cause = Throwables2.getFirstThrowableOfType(exception, clazz);
            if (cause == null) continue;
            return cause;
        }
        return null;
    }

    @VisibleForTesting
    static <T extends Throwable> T getFirstThrowableOfType(ProvisionException e, Class<T> clazz) {
        for (Message message : e.getErrorMessages()) {
            if (message.getCause() == null) continue;
            T cause = Throwables2.getFirstThrowableOfType(message.getCause(), clazz);
            if (cause instanceof ProvisionException) {
                return Throwables2.getFirstThrowableOfType((ProvisionException)ProvisionException.class.cast(cause), clazz);
            }
            if (cause instanceof TransformParallelException) {
                return Throwables2.getFirstThrowableOfType((TransformParallelException)TransformParallelException.class.cast(cause), clazz);
            }
            if (cause instanceof CreationException) {
                return Throwables2.getFirstThrowableOfType((CreationException)CreationException.class.cast(cause), clazz);
            }
            return cause;
        }
        return null;
    }

    @VisibleForTesting
    static <T extends Throwable> T getFirstThrowableOfType(CreationException e, Class<T> clazz) {
        for (Message message : e.getErrorMessages()) {
            if (message.getCause() == null) continue;
            T cause = Throwables2.getFirstThrowableOfType(message.getCause(), clazz);
            if (cause instanceof ProvisionException) {
                return Throwables2.getFirstThrowableOfType((ProvisionException)ProvisionException.class.cast(cause), clazz);
            }
            if (cause instanceof TransformParallelException) {
                return Throwables2.getFirstThrowableOfType((TransformParallelException)TransformParallelException.class.cast(cause), clazz);
            }
            if (cause instanceof CreationException) {
                return Throwables2.getFirstThrowableOfType((CreationException)CreationException.class.cast(cause), clazz);
            }
            return cause;
        }
        return null;
    }

    public static <T> T propagateAuthorizationOrOriginalException(Exception e) {
        AuthorizationException aex = Throwables2.getFirstThrowableOfType(e, AuthorizationException.class);
        if (aex != null) {
            throw aex;
        }
        throw Throwables.propagate(e);
    }

    public static void propagateIfPossible(Throwable exception, Iterable<TypeToken<? extends Throwable>> throwables) throws Throwable {
        Throwable throwable;
        for (TypeToken<? extends Throwable> typeToken : throwables) {
            throwable = Throwables2.getFirstThrowableOfType(exception, typeToken.getRawType());
            if (throwable == null) continue;
            throw throwable;
        }
        for (Class clazz : PROPAGATABLE_EXCEPTION_TYPES) {
            throwable = Throwables2.getFirstThrowableOfType(exception, clazz);
            if (throwable == null) continue;
            throw throwable;
        }
    }
}

