/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest;

import com.cdancy.jenkins.rest.JenkinsApi;
import com.cdancy.jenkins.rest.JenkinsApiMetadata;
import com.cdancy.jenkins.rest.JenkinsAuthentication;
import com.cdancy.jenkins.rest.JenkinsUtils;
import com.cdancy.jenkins.rest.auth.AuthenticationType;
import com.cdancy.jenkins.rest.config.JenkinsAuthenticationModule;
import com.google.common.collect.Lists;
import com.google.inject.Module;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.javax.annotation.Nullable;

public final class JenkinsClient
implements Closeable {
    private final String endPoint;
    private final JenkinsAuthentication credentials;
    private final JenkinsApi jenkinsApi;
    private final Properties overrides;

    public JenkinsClient() {
        this(null, null, null, null);
    }

    public JenkinsClient(@Nullable String endPoint, @Nullable JenkinsAuthentication authentication, @Nullable Properties overrides, @Nullable List<Module> modules) {
        this.endPoint = endPoint != null ? endPoint : JenkinsUtils.inferEndpoint();
        this.credentials = authentication != null ? authentication : JenkinsUtils.inferAuthentication();
        this.overrides = this.mergeOverrides(overrides);
        this.jenkinsApi = this.createApi(this.endPoint, this.credentials, this.overrides, modules);
    }

    private JenkinsApi createApi(String endPoint, JenkinsAuthentication authentication, Properties overrides, List<Module> modules) {
        ArrayList allModules = Lists.newArrayList((Object[])new Module[]{new JenkinsAuthenticationModule(authentication)});
        if (modules != null) {
            allModules.addAll(modules);
        }
        return (JenkinsApi)ContextBuilder.newBuilder((ApiMetadata)new JenkinsApiMetadata.Builder().build()).endpoint(endPoint).modules((Iterable)allModules).overrides(overrides).buildApi(JenkinsApi.class);
    }

    private Properties mergeOverrides(Properties possibleOverrides) {
        Properties inferOverrides = JenkinsUtils.inferOverrides();
        if (possibleOverrides != null) {
            inferOverrides.putAll((Map<?, ?>)possibleOverrides);
        }
        return inferOverrides;
    }

    public String endPoint() {
        return this.endPoint;
    }

    @Deprecated
    public String credentials() {
        return this.authValue();
    }

    public Properties overrides() {
        return this.overrides;
    }

    public String authValue() {
        return this.credentials.authValue();
    }

    public AuthenticationType authType() {
        return this.credentials.authType();
    }

    public JenkinsApi api() {
        return this.jenkinsApi;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() throws IOException {
        if (this.api() != null) {
            this.api().close();
        }
    }

    public static class Builder {
        private String endPoint;
        private JenkinsAuthentication.Builder authBuilder;
        private Properties overrides;
        private List<Module> modules = Lists.newArrayList();

        public Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public Builder credentials(String optionallyBase64EncodedCredentials) {
            this.authBuilder = JenkinsAuthentication.builder().credentials(optionallyBase64EncodedCredentials);
            return this;
        }

        public Builder apiToken(String apiToken) {
            this.authBuilder = JenkinsAuthentication.builder().apiToken(apiToken);
            return this;
        }

        public Builder overrides(Properties overrides) {
            this.overrides = overrides;
            return this;
        }

        public Builder modules(Module ... modules) {
            this.modules.addAll(Arrays.asList(modules));
            return this;
        }

        public JenkinsClient build() {
            JenkinsAuthentication authentication = this.authBuilder != null ? this.authBuilder.build() : null;
            return new JenkinsClient(this.endPoint, authentication, this.overrides, this.modules);
        }
    }
}

