/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.features;

import com.cdancy.jenkins.rest.domain.common.RequestStatus;
import com.cdancy.jenkins.rest.domain.user.ApiToken;
import com.cdancy.jenkins.rest.domain.user.User;
import com.cdancy.jenkins.rest.fallbacks.JenkinsFallbacks;
import com.cdancy.jenkins.rest.filters.JenkinsAuthenticationFilter;
import com.cdancy.jenkins.rest.filters.JenkinsUserInjectionFilter;
import com.cdancy.jenkins.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={JenkinsAuthenticationFilter.class, JenkinsUserInjectionFilter.class})
@Path(value="/user")
public interface UserApi {
    @Named(value="user:get")
    @Path(value="/{user}/api/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @GET
    public User get();

    @Named(value="user:generateNewToken")
    @Path(value="/{user}/descriptorByName/jenkins.security.ApiTokenProperty/generateNewToken")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/x-www-form-urlencoded"})
    @Payload(value="newTokenName={tokenName}")
    @POST
    public ApiToken generateNewToken(@PayloadParam(value="tokenName") String var1);

    @Named(value="user:revoke")
    @Path(value="/{user}/descriptorByName/jenkins.security.ApiTokenProperty/revoke")
    @Fallback(value=JenkinsFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @Produces(value={"application/x-www-form-urlencoded"})
    @Payload(value="tokenUuid={tokenUuid}")
    @POST
    public RequestStatus revoke(@PayloadParam(value="tokenUuid") String var1);
}

