/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence;

import io.github.cdimascio.essence.EssenceResult;
import io.github.cdimascio.essence.Language;
import io.github.cdimascio.essence.Link;
import io.github.cdimascio.essence.cleaners.Cleaner;
import io.github.cdimascio.essence.cleaners.ScoreCleaner;
import io.github.cdimascio.essence.extractors.Extractor;
import io.github.cdimascio.essence.formatters.TextFormatter;
import io.github.cdimascio.essence.scorers.DocumentScorer;
import io.github.cdimascio.essence.words.StopWords;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/cdimascio/essence/EssenceParser;", "", "html", "", "language", "Lio/github/cdimascio/essence/Language;", "(Ljava/lang/String;Lio/github/cdimascio/essence/Language;)V", "cleaner", "Lio/github/cdimascio/essence/cleaners/Cleaner;", "document", "Lorg/jsoup/nodes/Document;", "kotlin.jvm.PlatformType", "extractor", "Lio/github/cdimascio/essence/extractors/Extractor;", "formatter", "Lio/github/cdimascio/essence/formatters/TextFormatter;", "scoredCleaner", "Lio/github/cdimascio/essence/cleaners/ScoreCleaner;", "scorer", "Lio/github/cdimascio/essence/scorers/DocumentScorer;", "stopWords", "Lio/github/cdimascio/essence/words/StopWords;", "parse", "Lio/github/cdimascio/essence/EssenceResult;", "essence"})
public final class EssenceParser {
    private final Document document;
    private final Cleaner cleaner;
    private final Extractor extractor;
    private final Language language;
    private final StopWords stopWords;
    private final DocumentScorer scorer;
    private final ScoreCleaner scoredCleaner;
    private final TextFormatter formatter;
    private final String html;

    @NotNull
    public final EssenceResult parse() {
        String title = this.extractor.title();
        String softTitle = this.extractor.softTitle();
        String description = this.extractor.description();
        List<String> authors = this.extractor.authors();
        String copyright = this.extractor.copyright();
        String date = this.extractor.date();
        String favicon = this.extractor.favicon();
        String publisher = this.extractor.publisher();
        String image = this.extractor.image();
        List<String> tags = this.extractor.tags();
        String canonicalLink = this.extractor.canonicalLink();
        String keywords = this.extractor.keywords();
        Document doc = this.cleaner.clean();
        Element node = this.scorer.score(doc);
        Element topNode = this.scoredCleaner.clean(node);
        List<Link> links = this.extractor.links(topNode);
        String videos = this.extractor.videos(topNode);
        String text2 = this.extractor.text(topNode, this.formatter);
        List<String> list = tags;
        String string = keywords;
        String string2 = canonicalLink;
        List<Link> list2 = links;
        String string3 = image;
        String string4 = favicon;
        String string5 = text2;
        String string6 = this.language.name();
        String string7 = copyright;
        String string8 = date;
        String string9 = publisher;
        String string10 = description;
        String string11 = softTitle;
        String string12 = title;
        List<String> list3 = authors;
        return new EssenceResult(string5, string6, list3, string12, string11, string7, string8, string9, string10, string4, string3, list2, string2, string, list);
    }

    public EssenceParser(@NotNull String html, @Nullable Language language) {
        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
        this.html = html;
        Document document = this.document = Jsoup.parse((String)this.html);
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"document");
        this.cleaner = new Cleaner(document);
        Document document2 = this.document;
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
        this.extractor = new Extractor(document2);
        Language language2 = language;
        if (language2 == null) {
            language2 = Language.Companion.from(this.extractor.lang());
        }
        this.language = language2;
        this.stopWords = StopWords.Companion.load(this.language);
        this.scorer = new DocumentScorer(this.stopWords);
        this.scoredCleaner = new ScoreCleaner(this.stopWords);
        this.formatter = new TextFormatter(this.stopWords);
    }

    public /* synthetic */ EssenceParser(String string, Language language, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            language = null;
        }
        this(string, language);
    }
}

