/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence.cleaners;

import io.github.cdimascio.essence.cleaners.Cleaner;
import io.github.cdimascio.essence.cleaners.Traverse;
import io.github.cdimascio.essence.cleaners.rules.Rule;
import io.github.cdimascio.essence.util.TraversalHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0007H\u0002J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0002J\b\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/cdimascio/essence/cleaners/Cleaner;", "", "doc", "Lorg/jsoup/nodes/Document;", "(Lorg/jsoup/nodes/Document;)V", "clean", "cleanCodeBlocks", "", "cleanEmTags", "cleanParaSpans", "cleanUnderlines", "elementToParagraph", "tagNames", "", "", "getReplacementNodes", "Lorg/jsoup/nodes/Element;", "div", "Lorg/jsoup/nodes/Node;", "removeBodyClasses", "removeDropCaps", "removeScriptsStyles", "essence"})
public final class Cleaner {
    private final Document doc;

    @NotNull
    public final Document clean() {
        this.removeBodyClasses();
        this.cleanEmTags();
        this.cleanCodeBlocks();
        this.removeDropCaps();
        this.removeScriptsStyles();
        Object[] objectArray = new Function1[9];
        objectArray[0] = (Function1)new Function1<Node, Boolean>(Rule.INSTANCE){

            public final boolean invoke(@NotNull Node p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((Rule)this.receiver).removeCommentsTravRule(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "removeCommentsTravRule";
            }

            public final String getSignature() {
                return "removeCommentsTravRule(Lorg/jsoup/nodes/Node;)Z";
            }
        };
        objectArray[1] = (Function1)new Function1<Node, Boolean>(Rule.INSTANCE){

            public final boolean invoke(@NotNull Node p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((Rule)this.receiver).removeBadTagsTravRule(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "removeBadTagsTravRule";
            }

            public final String getSignature() {
                return "removeBadTagsTravRule(Lorg/jsoup/nodes/Node;)Z";
            }
        };
        objectArray[2] = (Function1)new Function1<Node, Boolean>(Rule.INSTANCE){

            public final boolean invoke(@NotNull Node p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((Rule)this.receiver).removeNavigationElements(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "removeNavigationElements";
            }

            public final String getSignature() {
                return "removeNavigationElements(Lorg/jsoup/nodes/Node;)Z";
            }
        };
        objectArray[3] = (Function1)new Function1<Node, Boolean>(Rule.INSTANCE){

            public final boolean invoke(@NotNull Node p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((Rule)this.receiver).removeSponsoredContent(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "removeSponsoredContent";
            }

            public final String getSignature() {
                return "removeSponsoredContent(Lorg/jsoup/nodes/Node;)Z";
            }
        };
        String string = "^caption$";
        Function1 function1 = (Function1)new Function1<Regex, Function1<? super Node, ? extends Boolean>>(Rule.INSTANCE){

            @NotNull
            public final Function1<Node, Boolean> invoke(@NotNull Regex p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((Rule)this.receiver).removeMatching(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "removeMatching";
            }

            public final String getSignature() {
                return "removeMatching(Lkotlin/text/Regex;)Lkotlin/jvm/functions/Function1;";
            }
        };
        int n = 4;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        Regex regex = new Regex(string);
        objectArray2[n] = (Function1)function1.invoke((Object)regex);
        string = " google ";
        function1 = (Function1)new Function1<Regex, Function1<? super Node, ? extends Boolean>>(Rule.INSTANCE){

            @NotNull
            public final Function1<Node, Boolean> invoke(@NotNull Regex p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((Rule)this.receiver).removeMatching(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "removeMatching";
            }

            public final String getSignature() {
                return "removeMatching(Lkotlin/text/Regex;)Lkotlin/jvm/functions/Function1;";
            }
        };
        n = 5;
        objectArray2 = objectArray3;
        regex = new Regex(string);
        objectArray2[n] = (Function1)function1.invoke((Object)regex);
        string = "^[^entry-]more.*$";
        function1 = (Function1)new Function1<Regex, Function1<? super Node, ? extends Boolean>>(Rule.INSTANCE){

            @NotNull
            public final Function1<Node, Boolean> invoke(@NotNull Regex p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((Rule)this.receiver).removeMatching(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "removeMatching";
            }

            public final String getSignature() {
                return "removeMatching(Lkotlin/text/Regex;)Lkotlin/jvm/functions/Function1;";
            }
        };
        n = 6;
        objectArray2 = objectArray3;
        regex = new Regex(string);
        objectArray2[n] = (Function1)function1.invoke((Object)regex);
        string = "([\"#.'\\-_]+|^)(fb|facebook)[\\-_\"']+|facebook-broadcasting";
        function1 = (Function1)new Function1<Regex, Function1<? super Node, ? extends Boolean>>(Rule.INSTANCE){

            @NotNull
            public final Function1<Node, Boolean> invoke(@NotNull Regex p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((Rule)this.receiver).removeMatching(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "removeMatching";
            }

            public final String getSignature() {
                return "removeMatching(Lkotlin/text/Regex;)Lkotlin/jvm/functions/Function1;";
            }
        };
        n = 7;
        objectArray2 = objectArray3;
        regex = new Regex(string);
        objectArray2[n] = (Function1)function1.invoke((Object)regex);
        string = "[^-]twitter";
        function1 = (Function1)new Function1<Regex, Function1<? super Node, ? extends Boolean>>(Rule.INSTANCE){

            @NotNull
            public final Function1<Node, Boolean> invoke(@NotNull Regex p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((Rule)this.receiver).removeMatching(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "removeMatching";
            }

            public final String getSignature() {
                return "removeMatching(Lkotlin/text/Regex;)Lkotlin/jvm/functions/Function1;";
            }
        };
        n = 8;
        objectArray2 = objectArray3;
        regex = new Regex(string);
        objectArray2[n] = (Function1)function1.invoke((Object)regex);
        List list = CollectionsKt.listOf((Object[])new KFunction[]{new Function1<Node, Unit>(Rule.INSTANCE){

            public final void invoke(@NotNull Node p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ((Rule)this.receiver).correctErrantLineBreaks(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "correctErrantLineBreaks";
            }

            public final String getSignature() {
                return "correctErrantLineBreaks(Lorg/jsoup/nodes/Node;)V";
            }
        }, new Function1<Node, Unit>(Rule.INSTANCE){

            public final void invoke(@NotNull Node p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ((Rule)this.receiver).cleanArticleTag(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Rule.class);
            }

            public final String getName() {
                return "cleanArticleTag";
            }

            public final String getSignature() {
                return "cleanArticleTag(Lorg/jsoup/nodes/Node;)V";
            }
        }});
        List list2 = CollectionsKt.listOf((Object[])objectArray3);
        new Traverse(list2, list).applyRules((Node)this.doc);
        this.cleanParaSpans();
        this.cleanUnderlines();
        this.elementToParagraph(this.doc, CollectionsKt.listOf((Object[])new String[]{"div", "span"}));
        return this.doc;
    }

    private final void removeBodyClasses() {
        Element body = this.doc.body();
        Set set = body.classNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"body.classNames()");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            body.removeClass(it);
        }
    }

    private final void cleanEmTags() {
        Elements ems;
        Elements elements = ems = this.doc.getElementsByTag("em");
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"ems");
        Iterable $receiver$iv = (Iterable)elements;
        for (Object element$iv : $receiver$iv) {
            Element it;
            Element element = it = (Element)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
            Elements images = TraversalHelpersKt.find(element, "img");
            if (!images.isEmpty()) continue;
            it.unwrap();
        }
    }

    private final void cleanCodeBlocks() {
        Elements nodes;
        Elements elements = nodes = this.doc.select("[class*='highlight-'], pre code, code, pre, ul.task-list");
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"nodes");
        Iterable $receiver$iv = (Iterable)elements;
        for (Object element$iv : $receiver$iv) {
            Element it = (Element)element$iv;
            it.unwrap();
        }
    }

    private final void removeDropCaps() {
        Elements nodes;
        Elements elements = nodes = this.doc.select("span[class~=dropcap], span[class~=drop_cap]");
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"nodes");
        Iterable $receiver$iv = (Iterable)elements;
        for (Object element$iv : $receiver$iv) {
            Element it = (Element)element$iv;
            it.unwrap();
        }
    }

    private final void removeScriptsStyles() {
        this.doc.getElementsByTag("script").remove();
        this.doc.getElementsByTag("style").remove();
    }

    private final void cleanParaSpans() {
        Elements elements = this.doc.select("p span");
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"doc.select(\"p span\")");
        Iterable $receiver$iv = (Iterable)elements;
        for (Object element$iv : $receiver$iv) {
            Element it = (Element)element$iv;
            it.unwrap();
        }
    }

    private final void cleanUnderlines() {
        Elements elements = this.doc.select("u");
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"doc.select(\"u\")");
        Iterable $receiver$iv = (Iterable)elements;
        for (Object element$iv : $receiver$iv) {
            Element it = (Element)element$iv;
            it.unwrap();
        }
    }

    private final void elementToParagraph(Document doc, List<String> tagNames) {
        Elements elements = doc.select(CollectionsKt.joinToString$default((Iterable)tagNames, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        List tags = CollectionsKt.listOf((Object[])new String[]{"a", "blockquote", "dl", "div", "img", "ol", "p", "pre", "table", "ul"});
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element element;
            Element element2 = element = (Element)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
            Elements items = TraversalHelpersKt.matchFirstElementTags(element2, tags, 1);
            if (items.isEmpty()) {
                String html = element.html();
                element.tagName("p");
                element.html(html);
                continue;
            }
            List<Element> replaceNodes = this.getReplacementNodes((Node)element);
            List pReplacementElements = new ArrayList();
            for (Element rNode : replaceNodes) {
                String string = rNode.html();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rNode.html()");
                CharSequence charSequence = string;
                if (!(charSequence.length() > 0)) continue;
                Element element3 = new Element("p").html(rNode.html());
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"Element(\"p\").html(rNode.html())");
                pReplacementElements.add(element3);
            }
            element.parent().insertChildren(element.siblingIndex(), (Collection)pReplacementElements);
            element.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Element> getReplacementNodes(Node div) {
        void $receiver$iv$iv;
        Object kidText;
        Collection kid2;
        List children = div.childNodes();
        List nodesToReturn = new ArrayList();
        List nodesToRemove = new ArrayList();
        List replacmentText = new ArrayList();
        Function1 isGravityUsed2 = getReplacementNodes.isGravityUsed.1.INSTANCE;
        Function1 setGravityUsed2 = getReplacementNodes.setGravityUsed.1.INSTANCE;
        for (Collection kid2 : children) {
            Collection collection;
            if (kid2 instanceof Element && Intrinsics.areEqual((Object)((Element)kid2).tagName(), (Object)"p") && !(collection = (Collection)replacmentText).isEmpty()) {
                String html = CollectionsKt.joinToString$default((Iterable)replacmentText, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                Element element = new Element("p").html(html);
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"Element(\"p\").html(html)");
                nodesToReturn.add(element);
                replacmentText.clear();
                nodesToReturn.add(kid2);
                continue;
            }
            if (kid2 instanceof TextNode) {
                String string = ((TextNode)kid2).text();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"kid.text()");
                kidText = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\\n", (String)"\n\n", (boolean)false, (int)4, null), (String)"\\t", (String)"", (boolean)false, (int)4, null), (String)"^\\s+$", (String)"", (boolean)false, (int)4, null);
                if (((String)kidText).length() <= 1) continue;
                Node prevSibling = kid2.previousSibling();
                while (prevSibling instanceof Element && Intrinsics.areEqual((Object)((Element)prevSibling).tagName(), (Object)"a") && !((Boolean)isGravityUsed2.invoke((Object)prevSibling)).booleanValue()) {
                    String outerHtml = ' ' + prevSibling.outerHtml() + ' ';
                    replacmentText.add(outerHtml);
                    nodesToRemove.add(prevSibling);
                    setGravityUsed2.invoke((Object)prevSibling);
                    prevSibling = prevSibling.previousSibling();
                }
                replacmentText.add(kidText);
                Node nextSibling = kid2.nextSibling();
                while (nextSibling instanceof Element && Intrinsics.areEqual((Object)((Element)nextSibling).tagName(), (Object)"a") && !((Boolean)isGravityUsed2.invoke((Object)nextSibling)).booleanValue()) {
                    String outerHtml = ' ' + nextSibling.outerHtml() + ' ';
                    replacmentText.add(outerHtml);
                    nodesToRemove.add(nextSibling);
                    setGravityUsed2.invoke((Object)nextSibling);
                    nextSibling = nextSibling.nextSibling();
                }
                continue;
            }
            if (!(kid2 instanceof Element)) continue;
            kidText = nodesToReturn;
            kidText.add(kid2);
        }
        kid2 = replacmentText;
        if (!kid2.isEmpty()) {
            String html = CollectionsKt.joinToString$default((Iterable)replacmentText, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            Element element = new Element("p").html(html);
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"Element(\"p\").html(html)");
            nodesToReturn.add(element);
            replacmentText.clear();
        }
        for (Node node : nodesToRemove) {
            node.remove();
        }
        Function1 isInteresting2 = getReplacementNodes.isInteresting.1.INSTANCE;
        Iterable $receiver$iv = nodesToReturn;
        kidText = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Element it = (Element)element$iv$iv;
            if (!((Boolean)isInteresting2.invoke((Object)it)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public Cleaner(@NotNull Document doc) {
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        this.doc = doc;
    }
}

