/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence.cleaners.rules;

import io.github.cdimascio.essence.cleaners.rules.Rule;
import io.github.cdimascio.essence.cleaners.rules.RuleKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lio/github/cdimascio/essence/cleaners/rules/Rule;", "", "()V", "cleanArticleTag", "", "node", "Lorg/jsoup/nodes/Node;", "correctErrantLineBreaks", "removeBadTagsTravRule", "", "removeCommentsTravRule", "removeMatching", "Lkotlin/Function1;", "re", "Lkotlin/text/Regex;", "removeNavigationElements", "removeSponsoredContent", "essence"})
public final class Rule {
    public static final Rule INSTANCE;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean removeSponsoredContent(@NotNull Node node) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (!(node instanceof Element)) {
            return false;
        }
        Regex regex = RuleKt.access$getREGEX_SPONSORED$p();
        String string = node.attr("class");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.attr(\"class\")");
        if (regex.containsMatchIn((CharSequence)string)) return true;
        Attributes attributes = node.attributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)attributes, (String)"node.attributes()");
        Iterable iterable = $receiver$iv = (Iterable)attributes;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Attribute it = (Attribute)element$iv$iv;
            String string2 = it.getValue();
            if (!RuleKt.access$getREGEX_SPONSORED$p().containsMatchIn(string2 != null ? (CharSequence)string2 : (CharSequence)"")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        if (collection.isEmpty()) return false;
        return true;
    }

    public final boolean removeCommentsTravRule(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return Intrinsics.areEqual((Object)node.nodeName(), (Object)"#comment");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean removeNavigationElements(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (!(node instanceof Element)) {
            return false;
        }
        if (!CollectionsKt.listOf((Object[])new String[]{"li", "ul", "ol", "header", "span"}).contains(((Element)node).tagName())) return false;
        Regex regex = RuleKt.access$getREGEX_NAV$p();
        String string = node.attr("class");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.attr(\"class\")");
        if (regex.containsMatchIn((CharSequence)string)) return true;
        Regex regex2 = RuleKt.access$getREGEX_NAV$p();
        String string2 = node.attr("id");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.attr(\"id\")");
        if (!regex2.containsMatchIn((CharSequence)string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean removeBadTagsTravRule(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Regex regex = RuleKt.access$getREGEX_BAD_TAGS$p();
        String string = node.attr("id");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.attr(\"id\")");
        if (regex.containsMatchIn((CharSequence)string)) return true;
        Regex regex2 = RuleKt.access$getREGEX_BAD_TAGS$p();
        String string2 = node.attr("class");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.attr(\"class\")");
        if (regex2.containsMatchIn((CharSequence)string2)) return true;
        Regex regex3 = RuleKt.access$getREGEX_BAD_TAGS$p();
        String string3 = node.attr("name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"node.attr(\"name\")");
        if (!regex3.containsMatchIn((CharSequence)string3)) return false;
        return true;
    }

    @NotNull
    public final Function1<Node, Boolean> removeMatching(@NotNull Regex re) {
        Intrinsics.checkParameterIsNotNull((Object)re, (String)"re");
        return (Function1)new Function1<Node, Boolean>(re){
            final /* synthetic */ Regex $re;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Node node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (!(node instanceof Element)) return false;
                if (!Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"div")) return false;
                String string = node.attr("id");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.attr(\"id\")");
                if (this.$re.containsMatchIn((CharSequence)string)) return true;
                String string2 = node.attr("class");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.attr(\"class\")");
                if (!this.$re.containsMatchIn((CharSequence)string2)) return false;
                return true;
            }
            {
                this.$re = regex;
                super(1);
            }
        };
    }

    public final void correctErrantLineBreaks(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (node instanceof Element && Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"p")) {
            for (TextNode textNode : ((Element)node).textNodes()) {
                String string = textNode.text();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"textNode.text()");
                CharSequence charSequence = string;
                String string2 = "([^\\n])\\n([^\\n])";
                string2 = new Regex(string2);
                Function1 function1 = correctErrantLineBreaks.text.1.INSTANCE;
                String text2 = string2.replace(charSequence, function1);
                textNode.text(text2);
            }
        }
    }

    public final void cleanArticleTag(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (node instanceof Element && Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"article")) {
            node.removeAttr("id");
            node.removeAttr("name");
            node.removeAttr("class");
        }
    }

    private Rule() {
    }

    static {
        Rule rule;
        INSTANCE = rule = new Rule();
    }
}

