/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence.extractors;

import io.github.cdimascio.essence.extractors.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/cdimascio/essence/extractors/DataExtractor;", "", "()V", "extract", "", "doc", "Lorg/jsoup/nodes/Document;", "essence"})
public final class DataExtractor {
    public static final DataExtractor INSTANCE;

    @NotNull
    public final String extract(@NotNull Document doc) {
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        Elements candidates = doc.select(StringsKt.trimIndent((String)"\n            meta[property='article:published_time'],\n            meta[itemprop*='datePublished'], meta[name='dcterms.modified'],\n            meta[name='dcterms.date'],\n            meta[name='DC.date.issued'],  meta[name='dc.date.issued'],\n            meta[name='dc.date.modified'], meta[name='dc.date.created'],\n            meta[name='DC.date'],\n            meta[name='DC.Date'],\n            meta[name='dc.date'],\n            meta[name='date'],\n            time[itemprop*='pubDate'],\n            time[itemprop*='pubdate'],\n            span[itemprop*='datePublished'],\n            span[property*='datePublished'],\n            p[itemprop*='datePublished'],\n            p[property*='datePublished'],\n            div[itemprop*='datePublished'],\n            div[property*='datePublished'],\n            li[itemprop*='datePublished'],\n            li[property*='datePublished'],\n            time,\n            span[class*='d  ate'],\n            p[class*='date'],\n            div[class*='date']\n        "));
        for (Element dateCandidate : candidates) {
            String string = dateCandidate.attr("content");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dateCandidate.attr(\"content\")");
            String content = ExtensionsKt.cleanse(string);
            CharSequence charSequence = content;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                return content;
            }
            String string2 = dateCandidate.attr("datetime");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateCandidate.attr(\"datetime\")");
            String datetime = ExtensionsKt.cleanse(string2);
            CharSequence charSequence2 = datetime;
            if (!StringsKt.isBlank((CharSequence)charSequence2)) {
                return datetime;
            }
            String string3 = dateCandidate.text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dateCandidate.text()");
            String text2 = ExtensionsKt.cleanse(string3);
            CharSequence charSequence3 = text2;
            if (!(!StringsKt.isBlank((CharSequence)charSequence3))) continue;
            return text2;
        }
        return "";
    }

    private DataExtractor() {
    }

    static {
        DataExtractor dataExtractor;
        INSTANCE = dataExtractor = new DataExtractor();
    }
}

