/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence.extractors;

import io.github.cdimascio.essence.Link;
import io.github.cdimascio.essence.extractors.AuthorExtractor;
import io.github.cdimascio.essence.extractors.CanonicalExtractor;
import io.github.cdimascio.essence.extractors.CopyrightExtractor;
import io.github.cdimascio.essence.extractors.DataExtractor;
import io.github.cdimascio.essence.extractors.DescriptionExtractor;
import io.github.cdimascio.essence.extractors.FaviconExtractor;
import io.github.cdimascio.essence.extractors.ImageExtractor;
import io.github.cdimascio.essence.extractors.KeywordsExtractor;
import io.github.cdimascio.essence.extractors.LanguageExtractor;
import io.github.cdimascio.essence.extractors.LinksExtractor;
import io.github.cdimascio.essence.extractors.PublisherExtractor;
import io.github.cdimascio.essence.extractors.SoftTitleExtractor;
import io.github.cdimascio.essence.extractors.TagsExtractor;
import io.github.cdimascio.essence.extractors.TextExtractor;
import io.github.cdimascio.essence.extractors.TitleExtractor;
import io.github.cdimascio.essence.extractors.VideosExtractor;
import io.github.cdimascio.essence.formatters.Formatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0007J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0018\u0010\u0017\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0007J\u0010\u0010\u001b\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/cdimascio/essence/extractors/Extractor;", "", "doc", "Lorg/jsoup/nodes/Document;", "(Lorg/jsoup/nodes/Document;)V", "authors", "", "", "canonicalLink", "copyright", "date", "description", "favicon", "image", "keywords", "lang", "links", "Lio/github/cdimascio/essence/Link;", "node", "Lorg/jsoup/nodes/Element;", "publisher", "softTitle", "tags", "text", "formatter", "Lio/github/cdimascio/essence/formatters/Formatter;", "title", "videos", "essence"})
public final class Extractor {
    private final Document doc;

    @NotNull
    public final String date() {
        return DataExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String copyright() {
        return CopyrightExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final List<String> authors() {
        return AuthorExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String publisher() {
        return PublisherExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String title() {
        return TitleExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String softTitle() {
        return SoftTitleExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String favicon() {
        return FaviconExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String description() {
        return DescriptionExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String keywords() {
        return KeywordsExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String lang() {
        return LanguageExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String canonicalLink() {
        return CanonicalExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final List<String> tags() {
        return TagsExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String image() {
        return ImageExtractor.INSTANCE.extract(this.doc);
    }

    @NotNull
    public final String videos(@Nullable Element node) {
        return VideosExtractor.INSTANCE.extract(node);
    }

    @NotNull
    public final List<Link> links(@Nullable Element node) {
        return LinksExtractor.INSTANCE.extract(node);
    }

    @NotNull
    public final String text(@Nullable Element node, @NotNull Formatter formatter) {
        Intrinsics.checkParameterIsNotNull((Object)formatter, (String)"formatter");
        return TextExtractor.INSTANCE.extract(node, formatter);
    }

    public Extractor(@NotNull Document doc) {
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        this.doc = doc;
    }
}

