/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence.extractors;

import io.github.cdimascio.essence.extractors.ExtensionsKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/cdimascio/essence/extractors/LanguageExtractor;", "", "()V", "extract", "", "doc", "Lorg/jsoup/nodes/Document;", "essence"})
public final class LanguageExtractor {
    public static final LanguageExtractor INSTANCE;

    @NotNull
    public final String extract(@NotNull Document doc) {
        String lang;
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        String string = lang = doc.select("html").attr("lang");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lang");
        if (StringsKt.isBlank((CharSequence)string)) {
            Object object = doc.selectFirst(StringsKt.trimIndent((String)"\n                meta[name=lang],\n                meta[http-equiv=content-language]\n            "));
            if (object == null || (object = object.attr("content")) == null) {
                object = "";
            }
            lang = object;
        }
        String string2 = lang;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"lang");
        CharSequence charSequence = string2;
        if (!StringsKt.isBlank((CharSequence)charSequence) && lang.length() >= 2) {
            charSequence = ExtensionsKt.cleanse(lang);
            int n = 0;
            int n2 = 2;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)charSequence2).substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            CharSequence charSequence3 = charSequence = string3;
            if (charSequence3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)charSequence3).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            return string4;
        }
        return "";
    }

    private LanguageExtractor() {
    }

    static {
        LanguageExtractor languageExtractor;
        INSTANCE = languageExtractor = new LanguageExtractor();
    }
}

