/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence.extractors;

import io.github.cdimascio.essence.extractors.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/github/cdimascio/essence/extractors/TagsExtractor;", "", "()V", "extract", "", "", "doc", "Lorg/jsoup/nodes/Document;", "essence"})
public final class TagsExtractor {
    public static final TagsExtractor INSTANCE;

    @NotNull
    public final List<String> extract(@NotNull Document doc) {
        CharSequence charSequence;
        String it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        Elements candidates = doc.select("a[rel='tag']");
        if (candidates.isEmpty()) {
            candidates = doc.select(StringsKt.trimIndent((String)"\n                a[href*='/tag/'],\n                a[href*='/tags/'],\n                a[href*='/topic/'],\n                a[href*='?keyword=']\n            "));
        }
        if (candidates.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Elements elements = candidates;
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"candidates");
        Iterable iterable = $receiver$iv = (Iterable)elements;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.text()");
            charSequence = ExtensionsKt.cleanse(string);
            String string2 = "[\\s\\t\\n]+";
            string2 = new Regex(string2);
            String string3 = " ";
            String string4 = string2.replace(charSequence, string3);
            collection.add(string4);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (String)element$iv$iv;
            charSequence = it;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private TagsExtractor() {
    }

    static {
        TagsExtractor tagsExtractor;
        INSTANCE = tagsExtractor = new TagsExtractor();
    }
}

