/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence.extractors;

import io.github.cdimascio.essence.extractors.ExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\"\u0010\u0004\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"biggestTitleChunk", "", "title", "delimiter", "cleanTitle", "delimiters", "", "rawTitle", "doc", "Lorg/jsoup/nodes/Document;", "essence"})
public final class TitleExtractorKt {
    private static final String rawTitle(Document doc) {
        String string;
        Element it;
        Element element;
        List candidates = new ArrayList();
        Elements elements = doc.select("meta[property='og:title']");
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"doc.select(\"\"\"meta[property='og:title']\"\"\")");
        candidates.addAll(CollectionsKt.toList((Iterable)((Iterable)elements)));
        Element element2 = doc.selectFirst("h1[class*='title']");
        if (element2 != null) {
            it = element = element2;
            candidates.add(it);
        }
        Element element3 = doc.selectFirst("title");
        if (element3 != null) {
            it = element = element3;
            candidates.add(it);
        }
        Element element4 = doc.selectFirst("h1");
        if (element4 != null) {
            it = element = element4;
            candidates.add(it);
        }
        Element element5 = doc.selectFirst("h2");
        if (element5 != null) {
            it = element = element5;
            candidates.add(it);
        }
        String text2 = null;
        for (Element c : candidates) {
            String string2 = text2 = c.attr("content");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
            if (StringsKt.isBlank((CharSequence)string2)) {
                text2 = c.text();
            }
            String string3 = text2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"text");
            CharSequence charSequence = string3;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            break;
        }
        if ((string = text2) == null || (string = ExtensionsKt.cleanse(string)) == null) {
            string = "";
        }
        return string;
    }

    private static final String cleanTitle(String title, List<String> delimiters) {
        String string = title;
        if (string == null) {
            string = "";
        }
        String t = string;
        for (String d : delimiters) {
            if (!StringsKt.contains$default((CharSequence)t, (CharSequence)d, (boolean)false, (int)2, null)) continue;
            t = TitleExtractorKt.biggestTitleChunk(t, d);
            break;
        }
        return ExtensionsKt.cleanse(t);
    }

    static /* synthetic */ String cleanTitle$default(String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return TitleExtractorKt.cleanTitle(string, list);
    }

    private static final String biggestTitleChunk(String title, String delimiter) {
        List titleParts = StringsKt.split$default((CharSequence)title, (String[])new String[]{delimiter}, (boolean)false, (int)0, (int)6, null);
        String largestPart = "";
        for (String part : titleParts) {
            if (part.length() <= largestPart.length()) continue;
            largestPart = part;
        }
        return largestPart;
    }

    @NotNull
    public static final /* synthetic */ String access$cleanTitle(@Nullable String title, @NotNull List delimiters) {
        return TitleExtractorKt.cleanTitle(title, delimiters);
    }

    @NotNull
    public static final /* synthetic */ String access$rawTitle(@NotNull Document doc) {
        return TitleExtractorKt.rawTitle(doc);
    }
}

