/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence.formatters;

import io.github.cdimascio.essence.formatters.Formatter;
import io.github.cdimascio.essence.formatters.TextFormatter;
import io.github.cdimascio.essence.util.TraversalHelpersKt;
import io.github.cdimascio.essence.words.StopWords;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u000f\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/cdimascio/essence/formatters/TextFormatter;", "Lio/github/cdimascio/essence/formatters/Formatter;", "stopWords", "Lio/github/cdimascio/essence/words/StopWords;", "(Lio/github/cdimascio/essence/words/StopWords;)V", "addNewlineToBr", "", "node", "Lorg/jsoup/nodes/Element;", "cleanParagraphText", "", "text", "convertToText", "Lorg/jsoup/nodes/Node;", "drillDownToCruxElement", "format", "linksToText", "removeFewwordsParagraphs", "removeNegativescoresNodes", "replaceWithText", "superSubScriptToText", "ulToText", "essence"})
public final class TextFormatter
implements Formatter {
    private final StopWords stopWords;

    @Override
    @NotNull
    public String format(@Nullable Element node) {
        Object object;
        block3: {
            block2: {
                Element element;
                object = node;
                if (object == null) break block2;
                Element it = element = object;
                Element bestRoot = this.drillDownToCruxElement(node);
                this.removeNegativescoresNodes(bestRoot);
                this.superSubScriptToText(bestRoot);
                this.linksToText(bestRoot);
                this.addNewlineToBr(bestRoot);
                this.replaceWithText(bestRoot);
                this.removeFewwordsParagraphs(bestRoot);
                String string = this.convertToText((Node)bestRoot);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final Element drillDownToCruxElement(Element node) {
        Node onlyChild;
        String string = node.ownText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.ownText()");
        if (StringsKt.isBlank((CharSequence)string) && node.childNodeSize() == 1 && (onlyChild = node.childNode(0)) instanceof Element) {
            this.drillDownToCruxElement((Element)onlyChild);
        }
        return node;
    }

    private final void removeNegativescoresNodes(Element node) {
        Elements gravityElements = TraversalHelpersKt.find(node, "*[gravityScore]");
        Iterable $receiver$iv = (Iterable)gravityElements;
        for (Object element$iv : $receiver$iv) {
            double score;
            double d;
            Element it = (Element)element$iv;
            try {
                String string;
                Intrinsics.checkExpressionValueIsNotNull((Object)it.attr("gravityScore"), (String)"it.attr(\"gravityScore\")");
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException e) {
                d = 0.0;
            }
            if (!((score = d) < 0.0)) continue;
            it.remove();
        }
    }

    private final void superSubScriptToText(Element node) {
        try {
            if (CollectionsKt.listOf((Object[])new String[]{"sub", "sup", "small"}).contains(node.tagName())) {
                String string;
                String string2 = node.ownText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.ownText()");
                String string3 = string = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                Double.parseDouble(string);
                if (node.hasParent()) {
                    node.unwrap();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private final void linksToText(Element node) {
        Elements nodes = TraversalHelpersKt.find(node, "a");
        Iterable $receiver$iv = (Iterable)nodes;
        for (Object element$iv : $receiver$iv) {
            Element it = (Element)element$iv;
            it.unwrap();
        }
    }

    private final void addNewlineToBr(Element node) {
        Elements brs = TraversalHelpersKt.find(node, "br");
        Iterable $receiver$iv = (Iterable)brs;
        for (Object element$iv : $receiver$iv) {
            Element it = (Element)element$iv;
            it.replaceWith((Node)new TextNode("\n\n"));
        }
    }

    private final void replaceWithText(Element node) {
        Elements nodes = TraversalHelpersKt.find(node, "b, strong, i, br, sup");
        Iterable $receiver$iv = (Iterable)nodes;
        for (Object element$iv : $receiver$iv) {
            Element it = (Element)element$iv;
            String string = it.text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.text()");
            CharSequence charSequence = string;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            it.unwrap();
        }
    }

    private final void removeFewwordsParagraphs(Element node) {
        Elements elements = TraversalHelpersKt.find(node, "*");
        for (Element e : elements) {
            boolean isEndline;
            String text2;
            String tag = e.tagName();
            String string = text2 = e.text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            int numStopWords = this.stopWords.statistics(string).getStopWords().size();
            Element element = e;
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"e");
            Collection collection = (Collection)TraversalHelpersKt.find(element, "object");
            boolean hasObject = !collection.isEmpty();
            Collection collection2 = (Collection)TraversalHelpersKt.find(e, "embed");
            boolean hasEmbed = !collection2.isEmpty();
            boolean bl = isEndline = Intrinsics.areEqual((Object)tag, (Object)"br") || Intrinsics.areEqual((Object)text2, (Object)"\\r");
            if (!(isEndline || numStopWords >= 3 || hasObject || hasEmbed)) {
                if (e.parent() == null) continue;
                e.remove();
                continue;
            }
            String string2 = text2;
            String trimmed = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            int numWords = StringsKt.split$default((CharSequence)text2, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null).size();
            CharSequence charSequence = trimmed;
            if (!(!StringsKt.isBlank((CharSequence)charSequence)) || numWords >= 25 || StringsKt.first((CharSequence)trimmed) != '(' || StringsKt.last((CharSequence)trimmed) != ')' || e.parent() == null) continue;
            e.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String convertToText(Node node) {
        void $receiver$iv$iv;
        Object object;
        Collection collection;
        List texts = new ArrayList();
        StringBuffer hangingText = new StringBuffer();
        for (Node child : node.childNodes()) {
            Object object2;
            Object object3;
            String text2;
            if (child instanceof TextNode) {
                hangingText.append(((TextNode)child).text());
                continue;
            }
            if (child instanceof Element && Intrinsics.areEqual((Object)((Element)child).tagName(), (Object)"ul")) {
                hangingText.append(this.ulToText((Element)child));
                continue;
            }
            CharSequence charSequence = hangingText;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                String string = hangingText.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hangingText.toString()");
                text2 = this.cleanParagraphText(string);
                object3 = text2;
                object2 = "\\r?\\n";
                collection = texts;
                object2 = object = new Regex((String)object2);
                int n = 0;
                object = object2.split((CharSequence)object3, n);
                collection.addAll((Collection)object);
                hangingText.setLength(0);
            }
            if (!(child instanceof Element)) continue;
            String string = ((Element)child).text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"child.text()");
            object3 = this.cleanParagraphText(string);
            object2 = "(\\\\w+\\\\.)([A-Z]+)";
            object2 = new Regex((String)object2);
            Function1 function1 = convertToText.text.1.INSTANCE;
            text2 = object2.replace((CharSequence)object3, function1);
            object3 = text2;
            object2 = "\\r?\\n";
            collection = texts;
            object2 = object = new Regex((String)object2);
            int n = 0;
            object = object2.split((CharSequence)object3, n);
            collection.addAll((Collection)object);
            object3 = hangingText;
            if (!(!StringsKt.isBlank((CharSequence)object3))) continue;
            String string2 = hangingText.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hangingText.toString()");
            String text3 = this.cleanParagraphText(string2);
            object2 = text3;
            Object object4 = "\\r?\\n";
            collection = texts;
            object4 = object = new Regex((String)object4);
            int n2 = 0;
            object = object4.split((CharSequence)object2, n2);
            collection.addAll((Collection)object);
        }
        Iterable $receiver$iv = texts;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            void var10_15;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            void v3 = var10_15 = it;
            if (v3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)((CharSequence)v3))).toString();
            collection.add(object);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String ulToText(Element node) {
        void $receiver$iv;
        String initial$iv;
        Elements nodes = TraversalHelpersKt.find(node, "li");
        Object object = (Iterable)nodes;
        String accumulator$iv = initial$iv = "";
        for (Object element$iv : $receiver$iv) {
            void n;
            Element element = (Element)element$iv;
            String text2 = accumulator$iv;
            accumulator$iv = text2 + "\n * " + n.text();
        }
        String text3 = accumulator$iv;
        object = text3;
        return !StringsKt.isBlank((CharSequence)object) ? "\n " + text3 : "";
    }

    private final String cleanParagraphText(String text2) {
        CharSequence charSequence;
        String string = charSequence = text2;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string2 = "[^\\S\\n]+";
        string2 = new Regex(string2);
        String string3 = " ";
        return StringsKt.replace$default((String)string2.replace(charSequence, string3), (String)"[\\n{3,]", (String)"\n\n", (boolean)false, (int)4, null);
    }

    public TextFormatter(@NotNull StopWords stopWords) {
        Intrinsics.checkParameterIsNotNull((Object)stopWords, (String)"stopWords");
        this.stopWords = stopWords;
    }
}

