/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence.scorers;

import io.github.cdimascio.essence.scorers.Scorer;
import io.github.cdimascio.essence.util.NodeHeuristics;
import io.github.cdimascio.essence.util.TraversalHelpers;
import io.github.cdimascio.essence.words.StopWords;
import io.github.cdimascio.essence.words.StopWordsStatistics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/github/cdimascio/essence/scorers/DocumentScorer;", "Lio/github/cdimascio/essence/scorers/Scorer;", "stopWords", "Lio/github/cdimascio/essence/words/StopWords;", "(Lio/github/cdimascio/essence/words/StopWords;)V", "findTopNode", "Lorg/jsoup/nodes/Element;", "scoredNodes", "", "isBoostable", "", "node", "Lorg/jsoup/nodes/Node;", "score", "Lio/github/cdimascio/essence/scorers/ScoredElement;", "doc", "Lorg/jsoup/nodes/Document;", "essence"})
public final class DocumentScorer
implements Scorer {
    private final StopWords stopWords;

    @Override
    @Nullable
    public Element score(@NotNull Document doc) {
        Iterator iterator;
        Elements nodesToCheck;
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        List nodesWithText = new ArrayList();
        Elements elements = nodesToCheck = doc.select("p, pre, td");
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"nodesToCheck");
        Iterable $receiver$iv = (Iterable)elements;
        for (Object element$iv : $receiver$iv) {
            String text2;
            Element node = (Element)element$iv;
            String string = text2 = node.text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            StopWordsStatistics wordStats = this.stopWords.statistics(string);
            Element element = node;
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"node");
            boolean hasHighLinkDensity = NodeHeuristics.INSTANCE.hasHighLinkDensity((Node)element);
            if (wordStats.getStopWords().size() <= 2 || hasHighLinkDensity) continue;
            nodesWithText.add(node);
        }
        int numNodesWithText = nodesWithText.size();
        double startingBoost = 1.0;
        boolean negativeScoring = false;
        double bottomNegativescoreNodes = (double)numNodesWithText * 0.25;
        Set parentNodes = new LinkedHashSet();
        Iterator iterator2 = iterator = CollectionsKt.withIndex(nodesWithText.iterator());
        while (iterator2.hasNext()) {
            Node node;
            Node grandParent;
            Element parent;
            String text3;
            double booster;
            double negScore;
            IndexedValue indexedValue = (IndexedValue)iterator2.next();
            int index = indexedValue.component1();
            Element node2 = (Element)indexedValue.component2();
            double boostScore = 0.0;
            if (this.isBoostable((Node)node2)) {
                boostScore = 1.0 / startingBoost * (double)50;
                startingBoost += 1.0;
            }
            if (numNodesWithText > 15 && (double)(numNodesWithText - index) <= bottomNegativescoreNodes && (negScore = Math.abs(boostScore = -1.0 * Math.pow(booster = bottomNegativescoreNodes - (double)(numNodesWithText - 1), 2.0)) + (double)negativeScoring) > (double)40) {
                boostScore = 5.0;
            }
            String string = text3 = node2.text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            StopWordsStatistics wordStats = this.stopWords.statistics(string);
            double upScore = Math.floor((double)wordStats.getStopWords().size() + boostScore);
            Element element = parent = node2.parent();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"parent");
            Scorer.Companion.updateScore$essence((Node)element, upScore);
            Scorer.Companion.updateNodeCount$essence((Node)parent, 1);
            if (!parentNodes.contains(parent)) {
                parentNodes.add(parent);
            }
            if ((grandParent = (Node)parent.parent()) == null) continue;
            Node it = node;
            Scorer.Companion.updateScore$essence(it, upScore / 2.0);
            Scorer.Companion.updateNodeCount$essence(it, 1);
            if (CollectionsKt.contains((Iterable)parentNodes, (Object)grandParent)) continue;
            parentNodes.add(grandParent);
        }
        return this.findTopNode(parentNodes);
    }

    private final Element findTopNode(Set<? extends Element> scoredNodes) {
        double topNodeScore = 0.0;
        Element topNode = null;
        for (Element element : scoredNodes) {
            double score = Scorer.Companion.getScore$essence((Node)element);
            if (score > topNodeScore) {
                topNodeScore = score;
                topNode = element;
            }
            if (topNode != null) continue;
            topNode = element;
        }
        return topNode;
    }

    private final boolean isBoostable(Node node) {
        Iterator iterator;
        List<Element> previousSiblings = TraversalHelpers.INSTANCE.getAllPreviousElementSiblings(node);
        int MIN_STOP_WORDS_COUNT = 5;
        int MAX_STEPS_FROM_NODE = 3;
        Iterator iterator2 = iterator = CollectionsKt.withIndex(previousSiblings.iterator());
        while (iterator2.hasNext()) {
            String text2;
            IndexedValue indexedValue = (IndexedValue)iterator2.next();
            int stepsAway = indexedValue.component1();
            Element element = (Element)indexedValue.component2();
            if (!Intrinsics.areEqual((Object)element.tagName(), (Object)"p")) continue;
            if (stepsAway >= MAX_STEPS_FROM_NODE) {
                return false;
            }
            String string = text2 = element.text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            StopWordsStatistics stats = this.stopWords.statistics(string);
            if (stats.getStopWords().size() <= MIN_STOP_WORDS_COUNT) continue;
            return true;
        }
        return false;
    }

    public DocumentScorer(@NotNull StopWords stopWords) {
        Intrinsics.checkParameterIsNotNull((Object)stopWords, (String)"stopWords");
        this.stopWords = stopWords;
    }
}

