/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.essence.util;

import io.github.cdimascio.essence.scorers.Scorer;
import io.github.cdimascio.essence.util.NodeHeuristics;
import io.github.cdimascio.essence.util.TraversalHelpersKt;
import io.github.cdimascio.essence.words.StopWords;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0011\u00a8\u0006\u0014"}, d2={"Lio/github/cdimascio/essence/util/NodeHeuristics;", "", "()V", "hasFewWordNextSiblings", "", "node", "Lorg/jsoup/nodes/Node;", "numSibsToCheck", "", "stopWords", "Lio/github/cdimascio/essence/words/StopWords;", "hasFewWordPrevSiblings", "hasFewWordsAndLowFewWordNeighbors", "hasHighLinkDensity", "isNodeThresholdMet", "parent", "child", "Lorg/jsoup/nodes/Element;", "isTableOrListWithNoParagraphs", "element", "essence"})
public final class NodeHeuristics {
    public static final NodeHeuristics INSTANCE;

    public final boolean isTableOrListWithNoParagraphs(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Elements paragraphs = TraversalHelpersKt.find(element, "p");
        List remainingParagraphs = new ArrayList();
        for (Element p : paragraphs) {
            String text2;
            String string = text2 = p.text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            CharSequence charSequence = string;
            if (!StringsKt.isBlank((CharSequence)charSequence) && text2.length() < 25) {
                p.remove();
                continue;
            }
            Element element2 = p;
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"p");
            remainingParagraphs.add(element2);
        }
        Collection collection = remainingParagraphs;
        return !collection.isEmpty() && CollectionsKt.listOf((Object[])new String[]{"td", "ul", "ol"}).contains(((Element)remainingParagraphs.get(0)).tagName());
    }

    public final boolean isNodeThresholdMet(@NotNull Node parent, @NotNull Element child) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        double parentNodeScore = Scorer.Companion.getScore$essence(parent);
        double childNodeScore = Scorer.Companion.getScore$essence((Node)child);
        double thresholdScore = parentNodeScore * 0.08;
        Function1 isAnExcludeTags2 = isNodeThresholdMet.isAnExcludeTags.1.INSTANCE;
        if (childNodeScore < thresholdScore) {
            String string = child.tagName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"child.tagName()");
            if (!((Boolean)isAnExcludeTags2.invoke((Object)string)).booleanValue()) {
                return false;
            }
        }
        return true;
    }

    public final boolean hasHighLinkDensity(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (node instanceof Element) {
            Collection collection;
            String text2;
            String string = text2 = ((Element)node).text();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            CharSequence charSequence = string;
            List words = !StringsKt.isBlank((CharSequence)charSequence) ? StringsKt.split$default((CharSequence)text2, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null) : CollectionsKt.emptyList();
            Elements links = TraversalHelpersKt.find((Element)node, "a");
            if (words.isEmpty() && !(collection = (Collection)links).isEmpty()) {
                return true;
            }
            collection = (Collection)links;
            if (!collection.isEmpty()) {
                double percentLinkWords = (double)links.size() / (double)words.size();
                double score = percentLinkWords * (double)links.size();
                return score >= 1.0;
            }
        }
        return false;
    }

    public final boolean hasFewWordsAndLowFewWordNeighbors(@NotNull Node node, @NotNull StopWords stopWords) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)stopWords, (String)"stopWords");
        if (node instanceof Element) {
            String ownText = ((Element)node).ownText();
            if (node.childNodeSize() == 0) {
                int n;
                String string = ownText;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ownText");
                if ((StringsKt.isBlank((CharSequence)string) || stopWords.statistics(ownText).getStopWords().size() < 5) && this.hasFewWordPrevSiblings(node, n = 2, stopWords) && this.hasFewWordNextSiblings(node, n, stopWords)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean hasFewWordPrevSiblings(Node node, int numSibsToCheck, StopWords stopWords) {
        int count = 0;
        for (Node prevSib = node.previousSibling(); prevSib != null && count < numSibsToCheck; prevSib = prevSib.previousSibling(), ++count) {
            String ownText;
            if (!(prevSib instanceof Element)) continue;
            String string = ownText = ((Element)prevSib).ownText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ownText");
            if (StringsKt.isBlank((CharSequence)string) || stopWords.statistics(ownText).getStopWords().size() <= 5) continue;
            return false;
        }
        return true;
    }

    private final boolean hasFewWordNextSiblings(Node node, int numSibsToCheck, StopWords stopWords) {
        int count = 0;
        for (Node nextSib = node.nextSibling(); nextSib != null && count < numSibsToCheck; nextSib = nextSib.nextSibling(), ++count) {
            String ownText;
            if (!(nextSib instanceof Element)) continue;
            String string = ownText = ((Element)nextSib).ownText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ownText");
            if (StringsKt.isBlank((CharSequence)string) || stopWords.statistics(ownText).getStopWords().size() <= 5) continue;
            return false;
        }
        return true;
    }

    private NodeHeuristics() {
    }

    static {
        NodeHeuristics nodeHeuristics;
        INSTANCE = nodeHeuristics = new NodeHeuristics();
    }
}

